/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.webgl;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.RendererException;
import nl.colorize.multimedialib.renderer.teavm.BrowserDOM;
import nl.colorize.multimedialib.renderer.teavm.HtmlCanvasGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.renderer.webgl.VertexData;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.stats.Cache;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLImageElement;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Float32Array;
import org.teavm.jso.webgl.WebGLBuffer;
import org.teavm.jso.webgl.WebGLProgram;
import org.teavm.jso.webgl.WebGLRenderingContext;
import org.teavm.jso.webgl.WebGLShader;
import org.teavm.jso.webgl.WebGLTexture;
import org.teavm.jso.webgl.WebGLUniformLocation;

public class WebGL
implements TeaGraphics {
    private Canvas canvas;
    private BrowserDOM dom;
    private HTMLCanvasElement glCanvas;
    private WebGLRenderingContext gl;
    private HtmlCanvasGraphics overlay;
    private WebGLProgram shaderProgram;
    private int aVertexPosition;
    private int aTextureCoordinates;
    private WebGLUniformLocation uColor;
    private WebGLUniformLocation uPositionVector;
    private WebGLUniformLocation uRotationVector;
    private WebGLUniformLocation uScaleVector;
    private Cache<TeaImage, VertexData> spriteVertexCache;
    private Cache<Shape, VertexData> shapeVertexCache;
    private Cache<TeaImage, WebGLTexture> textureCache;
    private Cache<Mask, WebGLTexture> maskTextureCache;
    private WebGLTexture nullTexture;
    private static final FilePointer VERTEX_SHADER_FILE = new FilePointer("vertex-shader.glsl");
    private static final FilePointer FRAGMENT_SHADER_FILE = new FilePointer("fragment-shader.glsl");

    public WebGL(Canvas canvas) {
        this.canvas = canvas;
        this.dom = new BrowserDOM();
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.MODE_3D;
    }

    @Override
    public int getDisplayWidth() {
        return this.glCanvas.getWidth();
    }

    @Override
    public int getDisplayHeight() {
        return this.glCanvas.getHeight();
    }

    @Override
    public void init(TeaMediaLoader mediaLoader) {
        HTMLDocument document = Window.current().getDocument();
        HTMLElement container = document.getElementById("multimediaLibContainer");
        this.glCanvas = this.dom.createFullScreenCanvas(container);
        this.gl = (WebGLRenderingContext)this.glCanvas.getContext("webgl");
        String vertexShader = mediaLoader.loadText(VERTEX_SHADER_FILE);
        String fragmentShader = mediaLoader.loadText(FRAGMENT_SHADER_FILE);
        this.initShaderProgram(vertexShader, fragmentShader);
        this.spriteVertexCache = Cache.from(this::createSpriteVertexData);
        this.shapeVertexCache = Cache.from(this::createShapeVertexData);
        this.textureCache = Cache.from(this::loadTexture);
        this.maskTextureCache = Cache.from(this::loadMaskTexture);
        this.nullTexture = this.loadTexture(this.dom.createColorCanvas(8, 8, ColorRGB.WHITE));
        this.initOverlay(mediaLoader);
    }

    private void initShaderProgram(String vertexShader, String fragmentShader) {
        this.shaderProgram = this.gl.createProgram();
        this.compileShader(35633, vertexShader);
        this.compileShader(35632, fragmentShader);
        this.gl.linkProgram(this.shaderProgram);
        if (this.gl.getProgramParameter(this.shaderProgram, 35714) == null) {
            throw new RendererException("Shader link error: " + this.gl.getProgramInfoLog(this.shaderProgram));
        }
        this.aVertexPosition = this.gl.getAttribLocation(this.shaderProgram, "aVertexPosition");
        this.aTextureCoordinates = this.gl.getAttribLocation(this.shaderProgram, "aTextureCoordinates");
        this.uColor = this.gl.getUniformLocation(this.shaderProgram, "uColor");
        this.uPositionVector = this.gl.getUniformLocation(this.shaderProgram, "uPositionVector");
        this.uRotationVector = this.gl.getUniformLocation(this.shaderProgram, "uRotationVector");
        this.uScaleVector = this.gl.getUniformLocation(this.shaderProgram, "uScaleVector");
    }

    private void compileShader(int shaderType, String glsl) {
        WebGLShader shader = this.gl.createShader(shaderType);
        this.gl.shaderSource(shader, glsl);
        this.gl.compileShader(shader);
        if (this.gl.getShaderParameter(shader, 35713) == null) {
            this.gl.deleteShader(shader);
            throw new RendererException("Shader compile error: " + this.gl.getShaderInfoLog(shader));
        }
        this.gl.attachShader(this.shaderProgram, shader);
    }

    private void initOverlay(TeaMediaLoader mediaLoader) {
        this.overlay = new HtmlCanvasGraphics(this.canvas);
        this.overlay.init(mediaLoader);
        this.overlay.getHtmlCanvas().getStyle().setProperty("position", "absolute");
        this.overlay.getHtmlCanvas().getStyle().setProperty("left", "0px");
        this.overlay.getHtmlCanvas().getStyle().setProperty("top", "0px");
        this.overlay.getHtmlCanvas().getStyle().setProperty("z-index", "2");
    }

    private VertexData createSpriteVertexData(TeaImage image) {
        WebGLBuffer vertexBuffer = this.gl.createBuffer();
        this.fillBuffer(vertexBuffer, -0.5f, -0.5f, 0.5f, 0.5f);
        WebGLBuffer textureBuffer = this.gl.createBuffer();
        this.fillBuffer(textureBuffer, 0.0f, 0.0f, 1.0f, 1.0f);
        WebGLTexture texture = (WebGLTexture)this.textureCache.get((Object)image.forParentImage());
        VertexData vertexData = new VertexData();
        vertexData.setVertices(6);
        vertexData.setVertexBuffer(vertexBuffer);
        vertexData.setTexture(texture);
        vertexData.setTextureCoordinateBuffer(textureBuffer);
        return vertexData;
    }

    private VertexData createShapeVertexData(Shape shape) {
        float[] vertices = this.toVertices(shape);
        WebGLBuffer vertexBuffer = this.gl.createBuffer();
        this.fillBuffer(vertexBuffer, vertices);
        WebGLBuffer textureBuffer = this.gl.createBuffer();
        this.fillBuffer(textureBuffer, -1.0f, -1.0f, -1.0f, -1.0f);
        VertexData vertexData = new VertexData();
        vertexData.setVertices(vertices.length / 2);
        vertexData.setVertexBuffer(vertexBuffer);
        vertexData.setTexture(this.nullTexture);
        vertexData.setTextureCoordinateBuffer(textureBuffer);
        return vertexData;
    }

    private WebGLTexture loadTexture(TeaImage image) {
        Preconditions.checkState((boolean)image.isLoaded(), (Object)"Image is still loading");
        Preconditions.checkState((boolean)image.isFullImage(), (Object)"Cannot create texture from image region");
        HTMLImageElement imageElement = image.getImageElement().get();
        WebGLTexture texture = this.gl.createTexture();
        this.gl.bindTexture(3553, texture);
        this.gl.texImage2D(3553, 0, 6408, 6408, 5121, imageElement);
        this.gl.texParameteri(3553, 10242, 10497);
        this.gl.texParameteri(3553, 10243, 10497);
        this.gl.texParameteri(3553, 10241, 9729);
        this.gl.pixelStorei(37440, 1);
        return texture;
    }

    private WebGLTexture loadTexture(HTMLCanvasElement canvasElement) {
        WebGLTexture texture = this.gl.createTexture();
        this.gl.bindTexture(3553, texture);
        this.gl.texImage2D(3553, 0, 6408, 6408, 5121, canvasElement);
        this.gl.texParameteri(3553, 10242, 10497);
        this.gl.texParameteri(3553, 10243, 10497);
        this.gl.texParameteri(3553, 10241, 9729);
        this.gl.pixelStorei(37440, 1);
        return texture;
    }

    private WebGLTexture loadMaskTexture(Mask mask) {
        HTMLCanvasElement maskCanvas = this.dom.applyMask(mask.image, mask.maskColor);
        return this.loadTexture(maskCanvas);
    }

    private void fillBuffer(WebGLBuffer buffer, float[] data) {
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"Missing 2D vertices");
        Preconditions.checkArgument((data.length % 2 == 0 ? 1 : 0) != 0, (Object)("Invalid 2D vertices: " + data.length));
        Float32Array wrapper = Float32Array.create((int)data.length);
        wrapper.set(data);
        this.gl.bindBuffer(34962, buffer);
        this.gl.bufferData(34962, (ArrayBufferView)wrapper, 35044);
    }

    private void fillBuffer(WebGLBuffer buffer, float x0, float y0, float x1, float y1) {
        float[] data = new float[]{x0, y0, x1, y0, x0, y1, x0, y1, x1, y0, x1, y1};
        this.fillBuffer(buffer, data);
    }

    private void render(VertexData vertexData) {
        this.gl.bindTexture(3553, vertexData.getTexture());
        this.gl.uniform4fv(this.uColor, vertexData.getColor());
        this.gl.uniform2fv(this.uPositionVector, vertexData.getPosition());
        this.gl.uniform2fv(this.uRotationVector, vertexData.getRotation());
        this.gl.uniform2fv(this.uScaleVector, vertexData.getScale());
        this.gl.bindBuffer(34962, vertexData.getVertexBuffer());
        this.gl.enableVertexAttribArray(this.aVertexPosition);
        this.gl.vertexAttribPointer(this.aVertexPosition, 2, 5126, false, 0, 0);
        this.gl.bindBuffer(34962, vertexData.getTextureCoordinateBuffer());
        this.gl.enableVertexAttribArray(this.aTextureCoordinates);
        this.gl.vertexAttribPointer(this.aTextureCoordinates, 2, 5126, false, 0, 0);
        this.gl.drawArrays(4, 0, vertexData.getVertices());
    }

    @Override
    public void prepareStage(Stage stage) {
        this.gl.viewport(0, 0, this.gl.getCanvas().getWidth(), this.gl.getCanvas().getHeight());
        this.gl.enable(3042);
        this.gl.blendFunc(1, 771);
        this.gl.enable(2929);
        this.gl.depthFunc(515);
        this.gl.useProgram(this.shaderProgram);
        this.overlay.prepareStage(stage);
    }

    @Override
    public void onGraphicAdded(Container parent, Graphic2D graphic) {
    }

    @Override
    public void onGraphicRemoved(Container parent, Graphic2D graphic) {
    }

    @Override
    public boolean visitGraphic(Graphic2D graphic) {
        return graphic.getTransform().isVisible();
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.gl.clearColor((float)color.r() / 255.0f, (float)color.g() / 255.0f, (float)color.b() / 255.0f, 1.0f);
        this.gl.clear(16384);
    }

    @Override
    public void drawSprite(Sprite sprite) {
        TeaImage image = (TeaImage)sprite.getCurrentGraphics();
        HTMLImageElement imageElement = image.getImagePromise().getValue().orElse(null);
        if (imageElement == null) {
            return;
        }
        VertexData vertexData = (VertexData)this.spriteVertexCache.get((Object)image);
        Region region = image.getRegion();
        Transform transform = sprite.getGlobalTransform();
        Point2D position = transform.getPosition();
        float zoomLevel = this.canvas.getZoomLevel();
        WebGLTexture originalTexture = vertexData.getTexture();
        if (transform.getMaskColor() != null) {
            WebGLTexture maskTexture = (WebGLTexture)this.maskTextureCache.get((Object)new Mask(image, transform.getMaskColor()));
            vertexData.setTexture(maskTexture);
        }
        this.fillBuffer(vertexData.getVertexBuffer(), (float)(-image.getWidth()) / (float)this.canvas.getScreenWidth(), (float)image.getHeight() / (float)this.canvas.getScreenHeight(), (float)image.getWidth() / (float)this.canvas.getScreenWidth(), (float)(-image.getHeight()) / (float)this.canvas.getScreenHeight());
        this.fillBuffer(vertexData.getTextureCoordinateBuffer(), (float)region.x() / (float)imageElement.getWidth(), 1.0f - (float)region.y() / (float)imageElement.getHeight(), (float)region.x1() / (float)imageElement.getWidth(), 1.0f - (float)region.y1() / (float)imageElement.getHeight());
        vertexData.setPosition(this.toGLX(position.getX()), this.toGLY(position.getY()));
        vertexData.setRotationInRadians(transform.getRotationInRadians());
        vertexData.setScale(transform.getScaleX() * zoomLevel, transform.getScaleY() * zoomLevel);
        this.render(vertexData);
        vertexData.setTexture(originalTexture);
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        this.overlay.drawLine(graphic, line);
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line) {
        this.overlay.drawSegmentedLine(graphic, line);
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        VertexData vertexData = (VertexData)this.shapeVertexCache.get((Object)rect);
        Transform transform = graphic.getGlobalTransform();
        this.fillBuffer(vertexData.getVertexBuffer(), this.toVertices(rect));
        vertexData.setColor(graphic.getColor(), transform.getAlpha());
        this.render(vertexData);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        this.overlay.drawCircle(graphic, circle);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        this.overlay.drawPolygon(graphic, polygon);
    }

    @Override
    public void drawText(Text text) {
        this.overlay.drawText(text);
    }

    private float[] toVertices(Shape shape) {
        if (shape instanceof Rect) {
            Rect rect = (Rect)shape;
            return this.toVertices(rect);
        }
        throw new RendererException("Cannot extract vertices: " + String.valueOf(shape.getClass()));
    }

    private float[] toVertices(Rect rect) {
        float x0 = this.toGLX(rect.getX());
        float y0 = this.toGLY(rect.getY());
        float x1 = this.toGLX(rect.getEndX());
        float y1 = this.toGLY(rect.getEndY());
        return new float[]{x0, y0, x1, y0, x0, y1, x0, y1, x1, y0, x1, y1};
    }

    protected float toGLX(float canvasX) {
        return canvasX / (float)this.canvas.getWidth() * 2.0f - 1.0f;
    }

    protected float toGLY(float canvasY) {
        return -1.0f * (canvasY / (float)this.canvas.getHeight() * 2.0f - 1.0f);
    }

    private record Mask(TeaImage image, ColorRGB maskColor) {
    }
}

