/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.math.Buffer;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;

public class SwipeTracker
implements Scene {
    private float tolerance;
    private Map<String, Point2D> incompleteSwipes;
    private Buffer<Line> swipes;

    public SwipeTracker(float tolerance) {
        Preconditions.checkArgument((tolerance >= 10.0f ? 1 : 0) != 0, (Object)("Invalid tolerance: " + tolerance));
        this.tolerance = tolerance;
        this.incompleteSwipes = new HashMap<String, Point2D>();
        this.swipes = new Buffer();
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        for (Pointer pointer : context.getInput().getPointers()) {
            if (this.incompleteSwipes.containsKey(pointer.getId())) {
                this.updateCurrentSwipe(pointer);
                continue;
            }
            this.checkSwipeStart(pointer);
        }
    }

    private void checkSwipeStart(Pointer pointer) {
        if (pointer.isPressed()) {
            this.incompleteSwipes.put(pointer.getId(), pointer.getPosition());
        }
    }

    private void updateCurrentSwipe(Pointer pointer) {
        if (pointer.isReleased()) {
            Point2D position;
            Point2D start = this.incompleteSwipes.get(pointer.getId());
            if (start.distanceTo(position = pointer.getPosition()) >= this.tolerance) {
                Line completedSwipe = new Line(start, position);
                this.swipes.push(completedSwipe);
            }
            this.incompleteSwipes.remove(pointer.getId());
        } else if (!pointer.isPressed()) {
            this.incompleteSwipes.remove(pointer.getId());
        }
    }

    public Buffer<Line> getSwipes() {
        return this.swipes;
    }
}

