/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.scene.Updatable;

public class Timer
implements Updatable {
    private float position;
    private float duration;

    public Timer(float duration) {
        Preconditions.checkArgument((duration >= 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        this.position = 0.0f;
        this.duration = duration;
    }

    @Override
    public void update(float deltaTime) {
        this.position = Math.min(this.position + deltaTime, this.duration);
    }

    public float getTime() {
        return this.position;
    }

    public float getTimeRemaining() {
        return this.duration - this.position;
    }

    public float getDuration() {
        return this.duration;
    }

    public boolean isCompleted() {
        return this.position >= this.duration;
    }

    public float getRatio() {
        return this.position / this.duration;
    }

    public void reset() {
        this.position = 0.0f;
    }

    public void end() {
        this.position = this.duration;
    }

    public String toString() {
        return MathUtils.format(this.position, 1) + " / " + MathUtils.format(this.duration, 1);
    }

    public static Timer none() {
        Timer timer = new Timer(0.0f);
        timer.end();
        return timer;
    }

    public static Timer infinite() {
        return new Timer(Float.MAX_VALUE);
    }

    public static Timer ended(float duration) {
        Timer timer = new Timer(duration);
        timer.end();
        return timer;
    }
}

