/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.util.UUID;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.StageLocation;
import nl.colorize.multimedialib.stage.Transform;

public interface Graphic2D
extends Updatable {
    public StageLocation getLocation();

    default public UUID getId() {
        return this.getLocation().getId();
    }

    default public void detach() {
        if (this.getLocation().getParent() != null) {
            this.getLocation().getParent().removeChild(this);
        }
    }

    default public Transform getTransform() {
        return this.getLocation().getLocalTransform();
    }

    default public void setPosition(float x, float y) {
        this.getTransform().setPosition(x, y);
    }

    default public void setPosition(Point2D position) {
        this.getTransform().setPosition(position);
    }

    default public Transform getGlobalTransform() {
        return this.getLocation().getGlobalTransform();
    }

    public Rect getStageBounds();
}

