/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.stage.ColorRGB;

public final class Transform {
    private boolean visible = true;
    private Point2D position = new Point2D(0.0f, 0.0f);
    private float rotation = 0.0f;
    private float scaleX = 100.0f;
    private float scaleY = 100.0f;
    private boolean flipHorizontal = false;
    private boolean flipVertical = false;
    private float alpha = 100.0f;
    private ColorRGB maskColor = null;

    public void setPosition(float x, float y) {
        this.position = new Point2D(x, y);
    }

    public void setX(float x) {
        this.position = new Point2D(x, this.position.getY());
    }

    public void setY(float y) {
        this.position = new Point2D(this.position.getX(), y);
    }

    public void addPosition(float deltaX, float deltaY) {
        this.position = new Point2D(this.position.getX() + deltaX, this.position.getY() + deltaY);
    }

    public void setRotation(float degrees) {
        this.rotation = degrees % (degrees >= 0.0f ? 360.0f : -360.0f);
    }

    public void addRotation(float degrees) {
        this.setRotation(this.getRotation() + degrees);
    }

    public float getRotationInRadians() {
        return (float)Math.toRadians(this.rotation);
    }

    public void setScale(float scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    public void setScale(float scaleX, float scaleY) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
    }

    public void setScaleX(float scaleX) {
        this.scaleX = Math.max(scaleX, 0.0f);
    }

    public float getScaleX() {
        return this.flipHorizontal ? -this.scaleX : this.scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = Math.max(scaleY, 0.0f);
    }

    public float getScaleY() {
        return this.flipVertical ? -this.scaleY : this.scaleY;
    }

    public void setAlpha(float alpha) {
        this.alpha = MathUtils.clamp(alpha, 0.0f, 100.0f);
    }

    public void set(Transform other) {
        this.setVisible(other.visible);
        this.setPosition(other.position.getX(), other.position.getY());
        this.setRotation(other.rotation);
        this.setScale(other.scaleX, other.scaleY);
        this.setFlipHorizontal(other.flipHorizontal);
        this.setFlipVertical(other.flipVertical);
        this.setAlpha(other.alpha);
        this.setMaskColor(other.maskColor);
    }

    public Transform combine(Transform parent) {
        Transform global = new Transform();
        global.setVisible(this.visible || parent.visible);
        global.setPosition(this.position.getX() + parent.position.getX(), this.position.getY() + parent.position.getY());
        global.setRotation(this.rotation + parent.rotation);
        global.setScale(this.combinePercentage(this.scaleX, parent.scaleX), this.combinePercentage(this.scaleY, parent.scaleY));
        global.setFlipHorizontal(this.flipHorizontal || parent.flipHorizontal);
        global.setFlipVertical(this.flipVertical || parent.flipVertical);
        global.setAlpha(this.combinePercentage(this.alpha, parent.alpha));
        global.setMaskColor(this.maskColor != null ? this.maskColor : parent.maskColor);
        return global;
    }

    private float combinePercentage(float value, float parentValue) {
        return value / 100.0f * (parentValue / 100.0f) * 100.0f;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean isFlipHorizontal() {
        return this.flipHorizontal;
    }

    public boolean isFlipVertical() {
        return this.flipVertical;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public ColorRGB getMaskColor() {
        return this.maskColor;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void setFlipHorizontal(boolean flipHorizontal) {
        this.flipHorizontal = flipHorizontal;
    }

    public void setFlipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
    }

    public void setMaskColor(ColorRGB maskColor) {
        this.maskColor = maskColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transform)) {
            return false;
        }
        Transform other = (Transform)o;
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (Float.compare(this.getRotation(), other.getRotation()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleX(), other.getScaleX()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleY(), other.getScaleY()) != 0) {
            return false;
        }
        if (this.isFlipHorizontal() != other.isFlipHorizontal()) {
            return false;
        }
        if (this.isFlipVertical() != other.isFlipVertical()) {
            return false;
        }
        if (Float.compare(this.getAlpha(), other.getAlpha()) != 0) {
            return false;
        }
        Point2D this$position = this.getPosition();
        Point2D other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        ColorRGB this$maskColor = this.getMaskColor();
        ColorRGB other$maskColor = other.getMaskColor();
        return !(this$maskColor == null ? other$maskColor != null : !((Object)this$maskColor).equals(other$maskColor));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getRotation());
        result = result * 59 + Float.floatToIntBits(this.getScaleX());
        result = result * 59 + Float.floatToIntBits(this.getScaleY());
        result = result * 59 + (this.isFlipHorizontal() ? 79 : 97);
        result = result * 59 + (this.isFlipVertical() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getAlpha());
        Point2D $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        ColorRGB $maskColor = this.getMaskColor();
        result = result * 59 + ($maskColor == null ? 43 : ((Object)$maskColor).hashCode());
        return result;
    }

    public String toString() {
        return "Transform(visible=" + this.isVisible() + ", position=" + String.valueOf(this.getPosition()) + ", rotation=" + this.getRotation() + ", scaleX=" + this.getScaleX() + ", scaleY=" + this.getScaleY() + ", flipHorizontal=" + this.isFlipHorizontal() + ", flipVertical=" + this.isFlipVertical() + ", alpha=" + this.getAlpha() + ", maskColor=" + String.valueOf(this.getMaskColor()) + ")";
    }
}

