/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Preconditions;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.util.FileUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.cli.Arg;
import nl.colorize.util.cli.CommandLineArgumentParser;
import nl.colorize.util.swing.Utils2D;

public class MacIconTool {
    @Arg(name="input", usage="PNG file that acts as input for the icon")
    protected File inputFile;
    @Arg(name="output", usage="Directory where the ICNS file will be generated")
    protected File outputDir;
    private static final List<IconVariant> MAC_ICON_VARIANTS = List.of(new IconVariant("icon_16x16.png", 16), new IconVariant("icon_16x16@2x.png", 32), new IconVariant("icon_32x32.png", 32), new IconVariant("icon_32x32@2x.png", 64), new IconVariant("icon_128x128.png", 128), new IconVariant("icon_128x128@2x.png", 256), new IconVariant("icon_256x256.png", 256), new IconVariant("icon_256x256@2x.png", 512), new IconVariant("icon_512x512.png", 512), new IconVariant("icon_512x512@2x.png", 1024));
    private static final Logger LOGGER = LogHelper.getLogger(MacIconTool.class);

    public static void main(String[] argv) {
        if (Platform.isMac()) {
            CommandLineArgumentParser argParser = new CommandLineArgumentParser("MacIconTool");
            MacIconTool tool = (MacIconTool)argParser.parse(argv, MacIconTool.class);
            tool.run();
        } else {
            LOGGER.severe("This tool can only be used on Mac");
            System.exit(1);
        }
    }

    protected void run() {
        try {
            BufferedImage original = Utils2D.loadImage((File)this.inputFile);
            this.generateIconSet(original);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Failed to generate ICNS icon", e);
        }
    }

    private void generateIconSet(BufferedImage original) throws IOException, InterruptedException {
        File iconSet = new File(this.outputDir, "icon.iconset");
        FileUtils.mkdir((File)iconSet);
        for (IconVariant variant : MAC_ICON_VARIANTS) {
            BufferedImage scaled = Utils2D.scaleImage((Image)original, (int)variant.size, (int)variant.size, (boolean)false);
            Utils2D.savePNG((BufferedImage)scaled, (File)new File(iconSet, variant.name));
        }
        int exitCode = new ProcessBuilder("iconutil", "-c", "icns", "icon.iconset").directory(this.outputDir).redirectError(ProcessBuilder.Redirect.PIPE).start().waitFor();
        Preconditions.checkState((exitCode == 0 ? 1 : 0) != 0, (Object)("iconutil failed with exit code " + exitCode));
    }

    private record IconVariant(String name, int size) {
    }
}

