/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

public record Angle(float degrees) {
    public static final Angle ORIGIN = new Angle(0.0f);

    public Angle(float degrees) {
        while (degrees < 0.0f) {
            degrees += 360.0f;
        }
        this.degrees = degrees % 360.0f;
    }

    public float getRadians() {
        return (float)Math.toRadians(this.degrees);
    }

    public float difference(Angle other) {
        float phi = Math.abs(other.degrees - this.degrees) % 360.0f;
        if (phi > 180.0f) {
            phi = 360.0f - phi;
        }
        return phi;
    }

    public Angle move(Angle other) {
        return new Angle(this.degrees + other.degrees);
    }

    public Angle move(float byDegrees) {
        return new Angle(this.degrees + byDegrees);
    }

    public Angle opposite() {
        return new Angle(this.degrees + 180.0f);
    }

    @Override
    public String toString() {
        return Math.round(this.degrees) + "\u00b0";
    }
}

