/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;

public record SegmentedLine(List<Point2D> points) implements Shape
{
    public SegmentedLine {
        Preconditions.checkArgument((points.size() >= 2 ? 1 : 0) != 0, (Object)("Too few points: " + points.size()));
    }

    public List<Line> getSegments() {
        ArrayList<Line> segments = new ArrayList<Line>();
        for (int i = 1; i < this.points.size(); ++i) {
            segments.add(new Line(this.points.get(i - 1), this.points.get(i)));
        }
        return segments;
    }

    public Point2D getHead() {
        return this.points.getFirst();
    }

    public Point2D getTail() {
        return this.points.getLast();
    }

    @Override
    public boolean contains(Point2D p) {
        return this.points.contains(p);
    }

    @Override
    public Rect getBoundingBox() {
        float minX = this.points.getFirst().x();
        float maxX = this.points.getFirst().x();
        float minY = this.points.getFirst().y();
        float maxY = this.points.getFirst().y();
        for (int i = 1; i < this.points.size(); ++i) {
            minX = Math.min(minX, this.points.get(i).x());
            maxX = Math.max(maxX, this.points.get(i).x());
            minY = Math.min(minY, this.points.get(i).y());
            maxY = Math.max(maxY, this.points.get(i).y());
        }
        return Rect.fromPoints(minX, minY, maxX, maxY);
    }

    @Override
    public SegmentedLine reposition(Point2D offset) {
        List<Point2D> pointsCopy = this.points.stream().map(p -> new Point2D(p.x() + offset.x(), p.y() + offset.y())).toList();
        return new SegmentedLine(pointsCopy);
    }

    public Line toDirectLine() {
        return new Line(this.getHead(), this.getTail());
    }

    public SegmentedLine extend(Point2D p) {
        ArrayList<Point2D> extendedPoints = new ArrayList<Point2D>();
        extendedPoints.addAll(this.points);
        extendedPoints.add(p);
        return new SegmentedLine(extendedPoints);
    }

    @Override
    public String toString() {
        return Joiner.on((String)" -> ").join(this.points);
    }
}

