/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import nl.colorize.multimedialib.math.Angle;
import nl.colorize.multimedialib.math.Point2D;

public record Vector(Point2D origin, Angle direction, float magnitude) {
    public Vector(Angle direction, float magnitude) {
        this(Point2D.ORIGIN, direction, magnitude);
    }

    public Vector(float direction, float magnitude) {
        this(Point2D.ORIGIN, new Angle(direction), magnitude);
    }

    public float getX() {
        return this.origin.x() + this.magnitude * (float)Math.cos(this.direction.getRadians());
    }

    public float getY() {
        return this.origin.y() + this.magnitude * (float)Math.sin(this.direction.getRadians());
    }

    public Point2D toPoint() {
        return new Point2D(this.getX(), this.getY());
    }

    public Vector withDirection(Angle newDirection) {
        return new Vector(this.origin, newDirection, this.magnitude);
    }

    public Vector withDirection(float newDirection) {
        return new Vector(this.origin, new Angle(newDirection), this.magnitude);
    }

    public Vector withMagnitude(float newMagnitude) {
        return new Vector(this.origin, this.direction, newMagnitude);
    }

    @Override
    public String toString() {
        Object result = String.format("[ %s %d ]", this.direction, Math.round(this.magnitude));
        if (!this.origin.equals(Point2D.ORIGIN)) {
            result = String.valueOf(this.origin) + " " + (String)result;
        }
        return result;
    }

    public static Vector fromPoint(Point2D p) {
        if (p.isOrigin()) {
            return new Vector(0.0f, 0.0f);
        }
        float direction = (float)Math.toDegrees(Math.atan2(p.y(), p.x()));
        float magnitude = new Point2D(0.0f, 0.0f).distanceTo(p);
        return new Vector(direction, magnitude);
    }
}

