/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.util.TextUtils;

public class Canvas {
    private int preferredWidth;
    private int preferredHeight;
    private ScaleStrategy scaleStrategy;
    private int screenWidth;
    private int screenHeight;
    private int offsetX;
    private int offsetY;

    public Canvas(int preferredWidth, int preferredHeight, ScaleStrategy scaleStrategy) {
        Preconditions.checkArgument((preferredWidth > 0 ? 1 : 0) != 0, (Object)"Invalid width");
        Preconditions.checkArgument((preferredHeight > 0 ? 1 : 0) != 0, (Object)"Invalid height");
        this.preferredWidth = preferredWidth;
        this.preferredHeight = preferredHeight;
        this.scaleStrategy = scaleStrategy;
        this.screenWidth = preferredWidth;
        this.screenHeight = preferredHeight;
        this.offsetX = 0;
        this.offsetY = 0;
    }

    public void resizeScreen(int screenWidth, int screenHeight) {
        this.screenWidth = Math.max(screenWidth, 1);
        this.screenHeight = Math.max(screenHeight, 1);
    }

    public void offsetScreen(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public int getWidth() {
        return Math.round((float)this.screenWidth / this.getZoomLevel());
    }

    public int getHeight() {
        return Math.round((float)this.screenHeight / this.getZoomLevel());
    }

    public Rect getBounds() {
        return new Rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    public Point2D getCenter() {
        return new Point2D((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    public boolean isLandscape() {
        return this.screenWidth >= this.screenHeight;
    }

    public boolean isPortait() {
        return !this.isLandscape();
    }

    public float getZoomLevel() {
        return this.scaleStrategy.getZoomLevel(this);
    }

    public float toCanvasX(int screenX) {
        return (float)(screenX - this.offsetX) / this.getZoomLevel();
    }

    public float toCanvasX(Point2D point) {
        return this.toCanvasX(Math.round(point.x()));
    }

    public float toCanvasY(int screenY) {
        return (float)(screenY - this.offsetY) / this.getZoomLevel();
    }

    public float toCanvasY(Point2D point) {
        return this.toCanvasY(Math.round(point.y()));
    }

    public float toScreenX(float canvasX) {
        return canvasX * this.getZoomLevel() + (float)this.offsetX;
    }

    public float toScreenX(Point2D point) {
        return this.toScreenX(point.x());
    }

    public float toScreenY(float canvasY) {
        return canvasY * this.getZoomLevel() + (float)this.offsetY;
    }

    public float toScreenY(Point2D point) {
        return this.toScreenY(point.y());
    }

    public String toString() {
        float zoomLevel = this.getZoomLevel();
        return this.getWidth() + "x" + this.getHeight() + " @ " + TextUtils.numberFormat((float)zoomLevel, (int)1) + "x";
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public ScaleStrategy getScaleStrategy() {
        return this.scaleStrategy;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }
}

