/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Properties;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.SpriteAtlasLoader;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.multimedialib.stage.SpriteAtlas;
import nl.colorize.util.PropertyUtils;
import nl.colorize.util.TranslationBundle;

public interface MediaLoader {
    public Image loadImage(FilePointer var1);

    default public SpriteAtlas loadAtlas(FilePointer file) {
        SpriteAtlasLoader atlasLoader = new SpriteAtlasLoader(this);
        return atlasLoader.load(file);
    }

    public Audio loadAudio(FilePointer var1);

    public FontFace loadFont(FilePointer var1, String var2, FontStyle var3);

    default public FontFace loadDefaultFont(ColorRGB color) {
        FilePointer file = new FilePointer("OpenSans-Regular.ttf");
        FontStyle style = new FontStyle(12, false, color);
        return this.loadFont(file, "Open Sans", style);
    }

    public PolygonModel loadModel(FilePointer var1);

    public GeometryBuilder getGeometryBuilder();

    public String loadText(FilePointer var1);

    default public List<String> loadTextLines(FilePointer file) {
        return Splitter.on((String)"\n").splitToList((CharSequence)this.loadText(file));
    }

    default public Properties loadProperties(FilePointer file) {
        String contents = this.loadText(file);
        return PropertyUtils.loadProperties((String)contents);
    }

    default public TranslationBundle loadTranslationBundle(FilePointer file) {
        Properties properties = this.loadProperties(file);
        return TranslationBundle.from((Properties)properties);
    }

    public boolean containsResourceFile(FilePointer var1);

    public Properties loadApplicationData(String var1);

    public void saveApplicationData(String var1, Properties var2);
}

