/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;

public class Pointer {
    private String id;
    private Point2D position;
    private int state;
    public static final int STATE_IDLE = 0;
    public static final int STATE_PRESSED = 1;
    public static final int STATE_RELEASED = 2;

    public Pointer(String id) {
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Empty pointer ID");
        this.id = id;
        this.position = Point2D.ORIGIN;
        this.state = 0;
    }

    public boolean isPressed() {
        return this.state == 1;
    }

    public boolean isPressed(Rect bounds) {
        return this.state == 1 && bounds.contains(this.position);
    }

    public boolean isReleased() {
        return this.state == 2;
    }

    public boolean isReleased(Rect bounds) {
        return this.state == 2 && bounds.contains(this.position);
    }

    public String getId() {
        return this.id;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public int getState() {
        return this.state;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void setState(int state) {
        this.state = state;
    }
}

