/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.headless.HeadlessRenderer;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.jfx.JFXRenderer;
import nl.colorize.multimedialib.renderer.libgdx.GDXRenderer;
import nl.colorize.multimedialib.renderer.teavm.TeaRenderer;

public final class RendererLauncher {
    private DisplayMode displayMode;
    private WindowOptions windowOptions;

    private RendererLauncher() {
    }

    public Renderer forDesktop2D(String requestedRendererName) {
        Preconditions.checkState((this.windowOptions != null ? 1 : 0) != 0, (Object)"Launcher configuration is missing window options");
        return switch (requestedRendererName) {
            case "java2d" -> new Java2DRenderer(this.displayMode, this.windowOptions);
            case "javafx", "jfx" -> JFXRenderer.launch(this.displayMode, this.windowOptions);
            case "libgdx", "gdx" -> new GDXRenderer(GraphicsMode.MODE_2D, this.displayMode, this.windowOptions);
            default -> throw new UnsupportedOperationException("Requested renderer not supported");
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Renderer forDesktop3D(String requestedRendererName) {
        Preconditions.checkState((this.windowOptions != null ? 1 : 0) != 0, (Object)"Launcher configuration is missing window options");
        switch (requestedRendererName) {
            case "libgdx": 
            case "gdx": {
                return new GDXRenderer(GraphicsMode.MODE_3D, this.displayMode, this.windowOptions);
            }
            default: {
                throw new UnsupportedOperationException("Requested renderer not supported");
            }
        }
    }

    public Renderer forBrowser2D(String requestedRendererName) {
        return switch (requestedRendererName) {
            case "html5", "canvas" -> TeaRenderer.withCanvas(this.displayMode);
            case "webgl" -> TeaRenderer.withWebGL(GraphicsMode.MODE_2D, this.displayMode);
            case "pixi", "pixijs" -> TeaRenderer.withPixi(this.displayMode);
            default -> throw new UnsupportedOperationException("Requested renderer not supported");
        };
    }

    public Renderer forBrowser3D(String requestedRendererName) {
        return switch (requestedRendererName) {
            case "webgl" -> TeaRenderer.withWebGL(GraphicsMode.MODE_3D, this.displayMode);
            case "three", "threejs" -> TeaRenderer.withThree(this.displayMode);
            default -> throw new UnsupportedOperationException("Requested renderer not supported");
        };
    }

    public Renderer forHeadless() {
        return new HeadlessRenderer(this.displayMode, false);
    }

    public static RendererLauncher configure(DisplayMode displayMode, WindowOptions windowOptions) {
        RendererLauncher launcher = new RendererLauncher();
        launcher.displayMode = displayMode;
        launcher.windowOptions = windowOptions;
        return launcher;
    }

    public static RendererLauncher configure(DisplayMode displayMode) {
        RendererLauncher launcher = new RendererLauncher();
        launcher.displayMode = displayMode;
        return launcher;
    }
}

