/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import nl.colorize.multimedialib.renderer.Canvas;

@FunctionalInterface
public interface ScaleStrategy {
    public float getZoomLevel(Canvas var1);

    public static ScaleStrategy flexible() {
        return canvas -> 1.0f;
    }

    public static ScaleStrategy scale() {
        return canvas -> {
            float horizontal = (float)canvas.getScreenWidth() / (float)canvas.getPreferredWidth();
            float vertical = (float)canvas.getScreenHeight() / (float)canvas.getPreferredHeight();
            return Math.max(horizontal, vertical);
        };
    }

    public static ScaleStrategy fit() {
        return canvas -> {
            float horizontal = (float)canvas.getScreenWidth() / (float)canvas.getPreferredWidth();
            float vertical = (float)canvas.getScreenHeight() / (float)canvas.getPreferredHeight();
            return Math.min(horizontal, vertical);
        };
    }

    public static ScaleStrategy balanced() {
        return canvas -> {
            float horizontal = (float)canvas.getScreenWidth() / (float)canvas.getPreferredWidth();
            float vertical = (float)canvas.getScreenHeight() / (float)canvas.getPreferredHeight();
            return (horizontal + vertical) / 2.0f;
        };
    }
}

