/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.headless;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.headless.HeadlessMediaLoader;
import nl.colorize.multimedialib.renderer.java2d.StandardNetwork;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.StageVisitor;

@VisibleForTesting
public class HeadlessRenderer
implements Renderer,
InputDevice {
    private GraphicsMode graphicsMode = GraphicsMode.HEADLESS;
    private WindowOptions windowOptions = new WindowOptions("<headless>");
    private DisplayMode displayMode;
    private StageVisitor graphics;
    private HeadlessMediaLoader mediaLoader;
    private Network network;
    private SceneContext context;
    private boolean touchAvailable;
    private boolean keyboardAvailable;
    private Point2D pointer;
    private boolean pointerPressed;
    private boolean pointerReleased;
    public static final int DEFAULT_WIDTH = 800;
    public static final int DEFAULT_HEIGHT = 600;
    public static final int DEFAULT_FRAMERATE = 30;
    public static final FontFace DEFAULT_FONT = new FontFace(null, null, "sans-serif", new FontStyle(10, false, ColorRGB.BLACK));

    public HeadlessRenderer(DisplayMode displayMode, boolean graphicsEnvironmentEnabled) {
        this.displayMode = displayMode;
        this.graphics = null;
        this.mediaLoader = new HeadlessMediaLoader(graphicsEnvironmentEnabled);
        this.network = new StandardNetwork();
        this.context = new SceneContext(this, this.mediaLoader, this, this.network);
        this.touchAvailable = false;
        this.keyboardAvailable = false;
        this.pointer = new Point2D(0.0f, 0.0f);
        this.pointerPressed = false;
        this.pointerReleased = false;
    }

    public HeadlessRenderer(Canvas canvas, int framerate) {
        this(new DisplayMode(canvas, framerate), true);
    }

    public HeadlessRenderer() {
        this(new Canvas(800, 600, ScaleStrategy.flexible()), 30);
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        this.context.changeScene(initialScene);
        this.doFrame();
    }

    @Override
    public void terminate() {
        throw new UnsupportedOperationException();
    }

    public void doFrame() {
        this.context.update(1.0f / (float)this.displayMode.framerate());
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public Iterable<Pointer> getPointers() {
        Pointer pointerObject = new Pointer("headless");
        pointerObject.setPosition(this.pointer);
        if (this.pointerReleased) {
            pointerObject.setState(2);
        } else if (this.pointerPressed) {
            pointerObject.setState(1);
        } else {
            pointerObject.setState(0);
        }
        return List.of(pointerObject);
    }

    @Override
    public void clearPointerState() {
        this.pointerPressed = false;
        this.pointerReleased = false;
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        return false;
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        return false;
    }

    @Override
    public String requestTextInput(String label, String initialValue) {
        return null;
    }

    @Override
    public void fillClipboard(String text) {
    }

    public String toString() {
        return "<headless>";
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return this.graphicsMode;
    }

    public WindowOptions getWindowOptions() {
        return this.windowOptions;
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public StageVisitor getGraphics() {
        return this.graphics;
    }

    public HeadlessMediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    public Network getNetwork() {
        return this.network;
    }

    public SceneContext getContext() {
        return this.context;
    }

    @Override
    public boolean isTouchAvailable() {
        return this.touchAvailable;
    }

    @Override
    public boolean isKeyboardAvailable() {
        return this.keyboardAvailable;
    }

    public Point2D getPointer() {
        return this.pointer;
    }

    public boolean isPointerPressed() {
        return this.pointerPressed;
    }

    public boolean isPointerReleased() {
        return this.pointerReleased;
    }

    public void setGraphicsMode(GraphicsMode graphicsMode) {
        this.graphicsMode = graphicsMode;
    }

    public void setWindowOptions(WindowOptions windowOptions) {
        this.windowOptions = windowOptions;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public void setGraphics(StageVisitor graphics) {
        this.graphics = graphics;
    }

    public void setMediaLoader(HeadlessMediaLoader mediaLoader) {
        this.mediaLoader = mediaLoader;
    }

    public void setNetwork(Network network) {
        this.network = network;
    }

    public void setContext(SceneContext context) {
        this.context = context;
    }

    public void setTouchAvailable(boolean touchAvailable) {
        this.touchAvailable = touchAvailable;
    }

    public void setKeyboardAvailable(boolean keyboardAvailable) {
        this.keyboardAvailable = keyboardAvailable;
    }

    public void setPointer(Point2D pointer) {
        this.pointer = pointer;
    }

    public void setPointerPressed(boolean pointerPressed) {
        this.pointerPressed = pointerPressed;
    }

    public void setPointerReleased(boolean pointerReleased) {
        this.pointerReleased = pointerReleased;
    }
}

