/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;

public class AWTImage
implements Image {
    private BufferedImage image;
    private Region region;
    private FilePointer origin;

    public AWTImage(BufferedImage image, FilePointer origin) {
        Preconditions.checkArgument((image != null ? 1 : 0) != 0, (Object)"Image is null");
        this.image = image;
        this.region = new Region(0, 0, image.getWidth(), image.getHeight());
        this.origin = origin;
    }

    @Override
    public Image extractRegion(Region subRegion) {
        BufferedImage subImage = this.image.getSubimage(subRegion.x(), subRegion.y(), subRegion.width(), subRegion.height());
        return new AWTImage(subImage, this.origin);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        int rgba = this.image.getRGB(x, y);
        return new ColorRGB(rgba);
    }

    @Override
    public int getAlpha(int x, int y) {
        int rgba = this.image.getRGB(x, y);
        int alpha = rgba >> 24 & 0xFF;
        return Math.round((float)alpha / 2.55f);
    }

    public String toString() {
        if (this.origin == null) {
            return "AWTImage";
        }
        return this.origin.toString();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public FilePointer getOrigin() {
        return this.origin;
    }
}

