/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.java2d.AWTImage;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.stats.Cache;
import nl.colorize.util.swing.Utils2D;

public class Java2DGraphicsContext
implements StageVisitor {
    private Canvas canvas;
    private Graphics2D g2;
    private Cache<ColorRGB, Color> colorCache;
    private Cache<MaskImage, BufferedImage> maskCache;
    private Cache<CircleImage, BufferedImage> circleCache;
    private Cache<FontFace, Font> fontCache;
    private static final int CACHE_CAPACITY = 1000;

    protected Java2DGraphicsContext(Canvas canvas, Cache<FontFace, Font> fontCache) {
        this.canvas = canvas;
        this.colorCache = Cache.from(this::convertColor, (int)1000);
        this.maskCache = Cache.from(MaskImage::render, (int)1000);
        this.circleCache = Cache.from(CircleImage::render, (int)1000);
        this.fontCache = fontCache;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void bind(Graphics2D g2) {
        this.g2 = g2;
    }

    public void dispose() {
        if (this.g2 != null) {
            this.g2.dispose();
            this.g2 = null;
        }
    }

    @Override
    public void prepareStage(Stage stage) {
    }

    @Override
    public boolean shouldVisitAllGraphics() {
        return false;
    }

    @Override
    public void visitContainer(Container container) {
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        float width = this.canvas.toScreenX(this.canvas.getWidth());
        float height = this.canvas.toScreenY(this.canvas.getHeight());
        this.g2.setColor((Color)this.colorCache.get((Object)backgroundColor));
        this.g2.fillRect(0, 0, Math.round(width), Math.round(height) + 30);
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        float x0 = this.canvas.toScreenX(line.start().x());
        float y0 = this.canvas.toScreenY(line.start().y());
        float x1 = this.canvas.toScreenX(line.end().x());
        float y1 = this.canvas.toScreenY(line.end().y());
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(graphic.getTransform().getAlpha());
        this.g2.setStroke(new BasicStroke(graphic.getStroke()));
        this.g2.setColor((Color)this.colorCache.get((Object)graphic.getColor()));
        this.g2.drawLine(Math.round(x0), Math.round(y0), Math.round(x1), Math.round(y1));
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line) {
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(graphic.getTransform().getAlpha());
        this.g2.setStroke(new BasicStroke(graphic.getStroke()));
        this.g2.setColor((Color)this.colorCache.get((Object)graphic.getColor()));
        for (Line segment : line.getSegments()) {
            float x0 = this.canvas.toScreenX(segment.start().x());
            float y0 = this.canvas.toScreenY(segment.start().y());
            float x1 = this.canvas.toScreenX(segment.end().x());
            float y1 = this.canvas.toScreenY(segment.end().y());
            this.g2.drawLine(Math.round(x0), Math.round(y0), Math.round(x1), Math.round(y1));
        }
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        Transform transform = graphic.getGlobalTransform();
        float screenX = this.canvas.toScreenX(rect.x());
        float screenY = this.canvas.toScreenY(rect.y());
        float screenWidth = this.canvas.toScreenX(rect.getEndX()) - screenX;
        float screenHeight = this.canvas.toScreenY(rect.getEndY()) - screenY;
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(transform.getAlpha());
        this.g2.setColor((Color)this.colorCache.get((Object)graphic.getColor()));
        this.g2.fillRect(Math.round(screenX), Math.round(screenY), Math.round(screenWidth), Math.round(screenHeight));
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        CircleImage key = new CircleImage(circle.radius(), (Color)this.colorCache.get((Object)graphic.getColor()));
        BufferedImage image = (BufferedImage)this.circleCache.get((Object)key);
        Transform transform = new Transform();
        transform.setPosition(circle.center());
        transform.setAlpha(graphic.getGlobalTransform().getAlpha());
        this.drawImage(image, transform);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        Transform transform = graphic.getGlobalTransform();
        int[] px = new int[polygon.getNumPoints()];
        int[] py = new int[polygon.getNumPoints()];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            px[i] = Math.round(this.canvas.toScreenX(polygon.getPointX(i)));
            py[i] = Math.round(this.canvas.toScreenY(polygon.getPointY(i)));
        }
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(transform.getAlpha());
        this.g2.setColor((Color)this.colorCache.get((Object)graphic.getColor()));
        this.g2.fillPolygon(px, py, polygon.getNumPoints());
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawSprite(Sprite sprite) {
        AWTImage image = (AWTImage)sprite.getCurrentGraphics();
        this.drawImage(image.getImage(), sprite.getGlobalTransform());
    }

    private void drawImage(BufferedImage image, Transform transform) {
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(transform.getAlpha());
        AffineTransform transform2D = this.applyTransform(transform, image.getWidth(), image.getHeight());
        this.g2.drawImage(image, transform2D, null);
        if (transform.getMaskColor() != null) {
            MaskImage key = new MaskImage(image, (Color)this.colorCache.get((Object)transform.getMaskColor()));
            this.g2.drawImage((Image)this.maskCache.get((Object)key), transform2D, null);
        }
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawText(Text text) {
        Font font = (Font)this.fontCache.get((Object)text.getFont().scale(this.canvas));
        ColorRGB color = text.getFont().style().color();
        Transform transform = text.getGlobalTransform();
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(transform.getAlpha());
        this.g2.setColor((Color)this.colorCache.get((Object)color));
        this.g2.setFont(font);
        this.drawLines(text.getLines(), transform.getPosition(), text.getAlign(), text.getLineHeight());
        this.g2.setComposite(originalComposite);
    }

    private void drawLines(List<String> lines, Point2D position, Align align, float lineHeight) {
        for (int i = 0; i < lines.size(); ++i) {
            float screenX = this.canvas.toScreenX(position.x());
            float screenY = this.canvas.toScreenY(position.y() + (float)i * lineHeight);
            int estimatedWidth = this.g2.getFontMetrics().stringWidth(lines.get(i));
            if (align == Align.CENTER) {
                this.g2.drawString(lines.get(i), screenX - (float)estimatedWidth / 2.0f, screenY);
                continue;
            }
            if (align == Align.RIGHT) {
                this.g2.drawString(lines.get(i), screenX - (float)estimatedWidth, screenY);
                continue;
            }
            this.g2.drawString(lines.get(i), screenX, screenY);
        }
    }

    private AffineTransform applyTransform(Transform transform, int width, int height) {
        float screenX = this.canvas.toScreenX(transform.getPosition());
        float screenY = this.canvas.toScreenY(transform.getPosition());
        float scaleX = this.canvas.getZoomLevel() * (transform.getScaleX() / 100.0f);
        float scaleY = this.canvas.getZoomLevel() * (transform.getScaleY() / 100.0f);
        int screenWidth = (int)((float)width * scaleX);
        int screenHeight = (int)((float)height * scaleY);
        AffineTransform transform2D = new AffineTransform();
        transform2D.setToIdentity();
        transform2D.translate(screenX - (float)screenWidth / 2.0f, screenY - (float)screenHeight / 2.0f);
        transform2D.rotate(transform.getRotation().getRadians(), (double)screenWidth / 2.0, (double)screenHeight / 2.0);
        transform2D.scale(scaleX, scaleY);
        return transform2D;
    }

    private void applyAlphaComposite(float alpha) {
        if (alpha != 100.0f) {
            AlphaComposite alphaComposite = AlphaComposite.SrcOver.derive(alpha / 100.0f);
            this.g2.setComposite(alphaComposite);
        }
    }

    private Color convertColor(ColorRGB color) {
        return new Color(color.r(), color.g(), color.b());
    }

    private record CircleImage(float radius, Color color) {
        public BufferedImage render() {
            int size = Math.round(this.radius * 2.0f);
            BufferedImage image = new BufferedImage(size, size, 2);
            Graphics2D g2 = Utils2D.createGraphics((BufferedImage)image, (boolean)true, (boolean)false);
            g2.setColor(this.color);
            g2.fillOval(0, 0, size, size);
            g2.dispose();
            return image;
        }
    }

    private record MaskImage(BufferedImage original, Color maskColor) {
        public BufferedImage render() {
            BufferedImage image = new BufferedImage(this.original.getWidth(), this.original.getHeight(), 2);
            Graphics2D g2 = Utils2D.createGraphics((BufferedImage)image, (boolean)true, (boolean)false);
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.setComposite(AlphaComposite.SrcOver);
            g2.setColor(this.maskColor);
            g2.drawImage(this.original, 0, 0, this.original.getWidth(), this.original.getHeight(), null);
            g2.setComposite(AlphaComposite.SrcAtop);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.dispose();
            return image;
        }
    }
}

