/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.UnsupportedGraphicsModeException;
import nl.colorize.multimedialib.renderer.headless.HeadlessAudio;
import nl.colorize.multimedialib.renderer.java2d.AWTImage;
import nl.colorize.multimedialib.renderer.java2d.JavaSoundPlayer;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.PropertyUtils;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.stats.Cache;
import nl.colorize.util.swing.Utils2D;

public class StandardMediaLoader
implements MediaLoader {
    public static Map<String, Font> fontFamilies = new HashMap<String, Font>();
    public static Cache<FontFace, Font> fontCache = Cache.from(key -> StandardMediaLoader.prepareFont(key));
    private static final String APPLICATION_DATA_FILE_NAME = "data.properties";
    private static final Logger LOGGER = LogHelper.getLogger(StandardMediaLoader.class);

    protected ResourceFile locateFile(FilePointer location) {
        return new ResourceFile(location.path());
    }

    @Override
    public Image loadImage(FilePointer file) {
        try {
            ResourceFile source = this.locateFile(file);
            BufferedImage original = Utils2D.loadImage((InputStream)source.openStream());
            if (Platform.isWindows()) {
                return this.prepareImage(file, original);
            }
            return new AWTImage(original, file);
        }
        catch (IOException e) {
            throw new MediaException("Cannot load image from " + file.path(), e);
        }
    }

    private Image prepareImage(FilePointer file, BufferedImage original) {
        try {
            BufferedImage compatible = Utils2D.makeImageCompatible((BufferedImage)original);
            return new AWTImage(compatible, file);
        }
        catch (HeadlessException e) {
            return new AWTImage(original, file);
        }
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        if (Platform.isMac()) {
            return new JavaSoundPlayer(this.locateFile(file));
        }
        LOGGER.warning("Java Sound not supported on platform " + Platform.getPlatformName());
        return new HeadlessAudio();
    }

    @Override
    public FontFace loadFont(FilePointer file, String family, FontStyle style) {
        FontFace fontFace;
        block9: {
            ResourceFile source = this.locateFile(file);
            InputStream stream = source.openStream();
            try {
                Font font = Font.createFont(0, stream);
                if (!fontFamilies.containsKey(family)) {
                    fontFamilies.put(family, font);
                    GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                }
                fontFace = new FontFace(this, file, family, style).derive(style);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FontFormatException | IOException e) {
                    throw new MediaException("Cannot load font from " + file.path(), e);
                }
            }
            stream.close();
        }
        return fontFace;
    }

    @Override
    public String loadText(FilePointer file) {
        return this.locateFile(file).read(Charsets.UTF_8);
    }

    @Override
    public PolygonModel loadModel(FilePointer file) {
        throw new UnsupportedGraphicsModeException();
    }

    @Override
    public GeometryBuilder getGeometryBuilder() {
        throw new UnsupportedGraphicsModeException();
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        return this.locateFile(file).exists();
    }

    protected File getApplicationDataFile(String appName) {
        Preconditions.checkArgument((appName.length() >= 2 ? 1 : 0) != 0, (Object)"Invalid application name");
        return Platform.getApplicationData((String)appName, (String)APPLICATION_DATA_FILE_NAME);
    }

    @Override
    public Properties loadApplicationData(String appName) {
        File dataFile = this.getApplicationDataFile(appName);
        if (dataFile.exists()) {
            try {
                return PropertyUtils.loadProperties((File)dataFile, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to load application data", e);
            }
        }
        return new Properties();
    }

    @Override
    public void saveApplicationData(String appName, Properties data) {
        try {
            File dataFile = this.getApplicationDataFile(appName);
            PropertyUtils.saveProperties((Properties)data, (File)dataFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to save application data", e);
        }
    }

    private static Font prepareFont(FontFace key) {
        Font baseFont = fontFamilies.get(key.family());
        if (baseFont == null) {
            LOGGER.warning("Unknown font family: " + key.family());
            baseFont = new Font("sans-serif", 0, 10);
        }
        int variant = key.style().bold() ? 1 : 0;
        return baseFont.deriveFont(variant, key.style().size());
    }
}

