/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.jfx;

import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import nl.colorize.multimedialib.renderer.jfx.JFXGraphics;
import nl.colorize.multimedialib.renderer.jfx.JFXInput;
import nl.colorize.multimedialib.renderer.jfx.JFXRenderer;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.util.LogHelper;

public class JFXAnimationLoop
extends Application {
    private JFXRenderer renderer;
    private SceneContext context;
    private JFXGraphics graphics;
    private JFXInput input;
    private static final Logger LOGGER = LogHelper.getLogger(JFXAnimationLoop.class);

    public void start(Stage stage) throws Exception {
        this.renderer = JFXRenderer.accessInstance();
        this.context = this.renderer.getContext();
        this.graphics = this.renderer.getGraphics();
        this.input = this.renderer.getInput();
        this.populateUI(stage);
        this.startAnimationLoop();
    }

    private void populateUI(Stage stage) {
        int width = this.context.getCanvas().getWidth();
        int height = this.context.getCanvas().getHeight();
        Canvas fxCanvas = new Canvas((double)width, (double)height);
        Group root = new Group();
        root.getChildren().add((Object)fxCanvas);
        Scene fxScene = new Scene((Parent)root);
        this.graphics.init(fxCanvas);
        this.attachEventHandlers(fxScene, fxCanvas);
        stage.setScene(fxScene);
        stage.setTitle(this.renderer.getWindowOptions().getTitle());
        stage.setMaximized(this.renderer.getWindowOptions().isFullscreen());
        stage.requestFocus();
        stage.show();
    }

    private void attachEventHandlers(Scene fxScene, Canvas fxCanvas) {
        fxScene.widthProperty().addListener((value, old, width) -> this.resizeWidth(fxCanvas, (Number)width));
        fxScene.heightProperty().addListener((value, old, height) -> this.resizeHeight(fxCanvas, (Number)height));
        fxScene.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> this.input.mouseEventQueue.add((MouseEvent)e));
        fxScene.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> this.input.mouseEventQueue.add((MouseEvent)e));
        fxScene.addEventFilter(MouseEvent.MOUSE_MOVED, e -> this.input.mouseEventQueue.add((MouseEvent)e));
        fxScene.addEventFilter(KeyEvent.KEY_PRESSED, e -> this.input.keyEventQueue.add((KeyEvent)e));
        fxScene.addEventFilter(KeyEvent.KEY_RELEASED, e -> this.input.keyEventQueue.add((KeyEvent)e));
    }

    private void startAnimationLoop() {
        AnimationTimer animationLoop = new AnimationTimer(){

            public void handle(long time) {
                try {
                    if (JFXAnimationLoop.this.context.syncFrame() > 0) {
                        JFXAnimationLoop.this.context.getFrameStats().markStart("$$frameRender");
                        JFXAnimationLoop.this.context.getStage().visit(JFXAnimationLoop.this.graphics, JFXAnimationLoop.this.context.getSceneTime());
                        JFXAnimationLoop.this.context.getFrameStats().markEnd("$$frameRender");
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Exception in JavaFX animation loop", e);
                    JFXAnimationLoop.this.renderer.getErrorHandler().onError(JFXAnimationLoop.this.context, e);
                    this.stop();
                }
            }
        };
        animationLoop.start();
    }

    private void resizeWidth(Canvas fxCanvas, Number width) {
        int screenHeight = this.context.getCanvas().getScreenHeight();
        this.context.getCanvas().resizeScreen(width.intValue(), screenHeight);
        fxCanvas.setWidth((double)width.intValue());
    }

    private void resizeHeight(Canvas fxCanvas, Number height) {
        int screenWidth = this.context.getCanvas().getScreenWidth();
        this.context.getCanvas().resizeScreen(screenWidth, height.intValue());
        fxCanvas.setHeight((double)height.intValue());
    }
}

