/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.jfx;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import nl.colorize.multimedialib.stage.Audio;

public class JFXAudioPlayer
implements Audio {
    private Media media;
    private List<MediaPlayer> currentlyPlaying;

    protected JFXAudioPlayer(Media media) {
        this.media = media;
        this.currentlyPlaying = new ArrayList<MediaPlayer>();
    }

    @Override
    public void play(int volume, boolean loop) {
        Preconditions.checkArgument((volume >= 0 && volume <= 100 ? 1 : 0) != 0, (Object)("Invalid volume: " + volume));
        MediaPlayer mediaPlayer = new MediaPlayer(this.media);
        mediaPlayer.setVolume((double)volume / 100.0);
        mediaPlayer.setCycleCount(loop ? Integer.MAX_VALUE : 1);
        mediaPlayer.play();
        this.currentlyPlaying.add(mediaPlayer);
    }

    @Override
    public void stop() {
        for (MediaPlayer mediaPlayer : this.currentlyPlaying) {
            mediaPlayer.stop();
        }
        this.currentlyPlaying.clear();
    }
}

