/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.jfx;

import java.util.List;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.jfx.JFXImage;
import nl.colorize.multimedialib.renderer.jfx.JFXMediaLoader;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.stats.Cache;

public class JFXGraphics
implements StageVisitor {
    private DisplayMode displayMode;
    private JFXMediaLoader media;
    private Cache<MaskImageCacheKey, WritableImage> maskImageCache;
    private Canvas fxCanvas;
    private GraphicsContext gc;

    public JFXGraphics(DisplayMode displayMode, JFXMediaLoader media) {
        this.displayMode = displayMode;
        this.media = media;
        this.maskImageCache = Cache.from(this::createMaskImage);
    }

    protected void init(Canvas fxCanvas) {
        this.fxCanvas = fxCanvas;
        this.gc = fxCanvas.getGraphicsContext2D();
    }

    @Override
    public void prepareStage(Stage stage) {
    }

    @Override
    public boolean shouldVisitAllGraphics() {
        return false;
    }

    @Override
    public void visitContainer(Container container) {
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.gc.setFill((Paint)this.toColor(color));
        this.gc.fillRect(0.0, 0.0, this.fxCanvas.getWidth(), this.fxCanvas.getHeight());
    }

    @Override
    public void drawSprite(Sprite sprite) {
        JFXImage image = (JFXImage)sprite.getCurrentGraphics();
        Image fxImage = image.getImage();
        Region region = image.getRegion();
        Transform transform = sprite.getGlobalTransform();
        float zoom = this.displayMode.canvas().getZoomLevel();
        if (transform.getMaskColor() != null) {
            MaskImageCacheKey key = new MaskImageCacheKey(fxImage, transform.getMaskColor());
            fxImage = (Image)this.maskImageCache.get((Object)key);
        }
        this.gc.setGlobalAlpha((double)transform.getAlpha() / 100.0);
        this.gc.translate((double)this.toScreenX(transform.getX()), (double)this.toScreenY(transform.getY()));
        this.gc.rotate((double)transform.getRotation().degrees());
        this.gc.scale((double)(transform.getScaleX() * zoom) / 100.0, (double)(transform.getScaleY() * zoom) / 100.0);
        this.gc.drawImage(fxImage, (double)region.x(), (double)region.y(), (double)region.width(), (double)region.height(), (double)((float)(-region.width()) / 2.0f), (double)((float)(-region.height()) / 2.0f), (double)region.width(), (double)region.height());
        this.gc.setGlobalAlpha(1.0);
        this.gc.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        Transform transform = graphic.getGlobalTransform();
        this.gc.setStroke((Paint)this.toColor(graphic.getColor(), transform.getAlpha()));
        this.gc.beginPath();
        this.gc.moveTo((double)this.toScreenX(line.start().x()), (double)this.toScreenY(line.start().y()));
        this.gc.lineTo((double)this.toScreenX(line.end().x()), (double)this.toScreenY(line.end().y()));
        this.gc.closePath();
        this.gc.stroke();
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line) {
        List<Point2D> points = line.points();
        Transform transform = graphic.getGlobalTransform();
        this.gc.setStroke((Paint)this.toColor(graphic.getColor(), transform.getAlpha()));
        this.gc.beginPath();
        this.gc.moveTo((double)this.toScreenX(points.getFirst().x()), (double)this.toScreenY(points.getFirst().y()));
        for (int i = 1; i < points.size(); ++i) {
            this.gc.lineTo((double)this.toScreenX(points.get(i).x()), (double)this.toScreenY(points.get(i).y()));
        }
        this.gc.closePath();
        this.gc.stroke();
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        Transform transform = graphic.getGlobalTransform();
        float screenX = this.toScreenX(rect.x());
        float screenY = this.toScreenY(rect.y());
        float screenWidth = this.toScreenX(rect.getEndX()) - screenX;
        float screenHeight = this.toScreenY(rect.getEndY()) - screenY;
        this.gc.setFill((Paint)this.toColor(graphic.getColor(), transform.getAlpha()));
        this.gc.fillRect((double)screenX, (double)screenY, (double)screenWidth, (double)screenHeight);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        Transform transform = graphic.getGlobalTransform();
        float screenX0 = this.toScreenX(circle.center().x() - circle.radius());
        float screenY0 = this.toScreenY(circle.center().y() - circle.radius());
        float screenX1 = this.toScreenX(circle.center().x() + circle.radius());
        float screenY1 = this.toScreenY(circle.center().y() + circle.radius());
        this.gc.setFill((Paint)this.toColor(graphic.getColor(), transform.getAlpha()));
        this.gc.fillOval((double)screenX0, (double)screenY0, (double)(screenX1 - screenX0), (double)(screenY1 - screenY0));
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        Transform transform = graphic.getGlobalTransform();
        double[] screenX = new double[polygon.getNumPoints()];
        double[] screenY = new double[polygon.getNumPoints()];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            screenX[i] = this.toScreenX(polygon.getPointX(i));
            screenX[i] = this.toScreenY(polygon.getPointY(i));
        }
        this.gc.setFill((Paint)this.toColor(graphic.getColor(), transform.getAlpha()));
        this.gc.fillPolygon(screenX, screenY, polygon.getNumPoints());
    }

    @Override
    public void drawText(Text text) {
        FontFace scaled = text.getFont().scale(this.displayMode.canvas());
        Font font = this.media.getFont(scaled);
        Transform transform = text.getGlobalTransform();
        this.gc.setFont(font);
        this.gc.setTextAlign(this.toTextAlignment(text.getAlign()));
        this.gc.setFill((Paint)this.toColor(scaled.style().color()));
        this.gc.setGlobalAlpha((double)transform.getAlpha() / 100.0);
        text.forLines((i, line) -> {
            float screenX = this.toScreenX(transform.getX());
            float screenY = this.toScreenY(transform.getY() + (float)i.intValue() * text.getLineHeight());
            this.gc.fillText(line, (double)screenX, (double)screenY);
        });
        this.gc.setGlobalAlpha(1.0);
    }

    private WritableImage createMaskImage(MaskImageCacheKey key) {
        int width = (int)key.image.getWidth();
        int height = (int)key.image.getHeight();
        WritableImage maskImage = new WritableImage(width, height);
        PixelReader pixelReader = key.image.getPixelReader();
        PixelWriter pixelWriter = maskImage.getPixelWriter();
        Color maskColor = this.toColor(key.mask);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Color originalColor = pixelReader.getColor(x, y);
                if (!(originalColor.getOpacity() > 0.0)) continue;
                pixelWriter.setColor(x, y, maskColor);
            }
        }
        return maskImage;
    }

    private float toScreenX(float canvasX) {
        return this.displayMode.canvas().toScreenX(canvasX);
    }

    private float toScreenY(float canvasY) {
        return this.displayMode.canvas().toScreenY(canvasY);
    }

    private Color toColor(ColorRGB rgb) {
        return this.toColor(rgb, 100.0f);
    }

    private Color toColor(ColorRGB rgb, float alpha) {
        return new Color((double)rgb.r() / 255.0, (double)rgb.g() / 255.0, (double)rgb.b() / 255.0, (double)alpha / 100.0);
    }

    private TextAlignment toTextAlignment(Align align) {
        return switch (align) {
            default -> throw new MatchException(null, null);
            case Align.LEFT -> TextAlignment.LEFT;
            case Align.CENTER -> TextAlignment.CENTER;
            case Align.RIGHT -> TextAlignment.RIGHT;
        };
    }

    private record MaskImageCacheKey(Image image, ColorRGB mask) {
    }
}

