/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.jfx;

import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.paint.Color;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.stage.ColorRGB;

public class JFXImage
implements nl.colorize.multimedialib.stage.Image {
    private Image image;
    private Region region;
    private PixelReader pixels;

    protected JFXImage(Image image, Region region) {
        this.image = image;
        this.region = region;
    }

    @Override
    public JFXImage extractRegion(Region subRegion) {
        return new JFXImage(this.image, subRegion);
    }

    private void readPixels() {
        if (this.pixels == null) {
            this.pixels = this.image.getPixelReader();
        }
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        this.readPixels();
        Color pixel = this.pixels.getColor(x, y);
        int red = (int)Math.round(pixel.getRed() * 255.0);
        int green = (int)Math.round(pixel.getGreen() * 255.0);
        int blue = (int)Math.round(pixel.getBlue() * 255.0);
        return new ColorRGB(red, green, blue);
    }

    @Override
    public int getAlpha(int x, int y) {
        this.readPixels();
        Color pixel = this.pixels.getColor(x, y);
        return (int)Math.round(pixel.getOpacity() * 100.0);
    }

    public Image getImage() {
        return this.image;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public PixelReader getPixels() {
        return this.pixels;
    }
}

