/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.jfx;

import com.google.common.collect.ImmutableMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.util.swing.Popups;
import nl.colorize.util.swing.SwingUtils;

public class JFXInput
implements InputDevice {
    protected Queue<MouseEvent> mouseEventQueue;
    protected Queue<KeyEvent> keyEventQueue;
    private Canvas canvas;
    private Pointer mouse;
    private Map<KeyCode, Integer> keyboard;
    private static final Map<Integer, KeyCode> KEY_CODES = new ImmutableMap.Builder().put((Object)37, (Object)KeyCode.LEFT).put((Object)39, (Object)KeyCode.RIGHT).put((Object)38, (Object)KeyCode.UP).put((Object)40, (Object)KeyCode.DOWN).put((Object)10, (Object)KeyCode.ENTER).put((Object)32, (Object)KeyCode.SPACEBAR).put((Object)27, (Object)KeyCode.ESCAPE).put((Object)16, (Object)KeyCode.SHIFT).put((Object)8, (Object)KeyCode.BACKSPACE).put((Object)9, (Object)KeyCode.TAB).put((Object)65, (Object)KeyCode.A).put((Object)66, (Object)KeyCode.B).put((Object)67, (Object)KeyCode.C).put((Object)68, (Object)KeyCode.D).put((Object)69, (Object)KeyCode.E).put((Object)70, (Object)KeyCode.F).put((Object)71, (Object)KeyCode.G).put((Object)72, (Object)KeyCode.H).put((Object)73, (Object)KeyCode.I).put((Object)74, (Object)KeyCode.J).put((Object)75, (Object)KeyCode.K).put((Object)76, (Object)KeyCode.L).put((Object)77, (Object)KeyCode.M).put((Object)78, (Object)KeyCode.N).put((Object)79, (Object)KeyCode.O).put((Object)80, (Object)KeyCode.P).put((Object)81, (Object)KeyCode.Q).put((Object)82, (Object)KeyCode.R).put((Object)83, (Object)KeyCode.S).put((Object)84, (Object)KeyCode.T).put((Object)85, (Object)KeyCode.U).put((Object)86, (Object)KeyCode.V).put((Object)87, (Object)KeyCode.W).put((Object)88, (Object)KeyCode.X).put((Object)89, (Object)KeyCode.Y).put((Object)90, (Object)KeyCode.Z).put((Object)49, (Object)KeyCode.N1).put((Object)50, (Object)KeyCode.N2).put((Object)51, (Object)KeyCode.N3).put((Object)52, (Object)KeyCode.N4).put((Object)53, (Object)KeyCode.N5).put((Object)54, (Object)KeyCode.N6).put((Object)55, (Object)KeyCode.N7).put((Object)56, (Object)KeyCode.N8).put((Object)57, (Object)KeyCode.N9).put((Object)48, (Object)KeyCode.N0).put((Object)112, (Object)KeyCode.F1).put((Object)113, (Object)KeyCode.F2).put((Object)114, (Object)KeyCode.F3).put((Object)115, (Object)KeyCode.F4).put((Object)116, (Object)KeyCode.F5).put((Object)117, (Object)KeyCode.F6).put((Object)118, (Object)KeyCode.F7).put((Object)119, (Object)KeyCode.F8).put((Object)120, (Object)KeyCode.F9).put((Object)121, (Object)KeyCode.F10).put((Object)122, (Object)KeyCode.F11).put((Object)123, (Object)KeyCode.F12).put((Object)521, (Object)KeyCode.PLUS).put((Object)45, (Object)KeyCode.MINUS).put((Object)61, (Object)KeyCode.EQUALS).build();

    protected JFXInput(Canvas canvas) {
        this.canvas = canvas;
        this.mouse = new Pointer("mouse");
        this.keyboard = new HashMap<KeyCode, Integer>();
        for (KeyCode key : KeyCode.values()) {
            this.keyboard.put(key, 0);
        }
        this.mouseEventQueue = new LinkedList<MouseEvent>();
        this.keyEventQueue = new LinkedList<KeyEvent>();
    }

    @Override
    public void update(float deltaTime) {
        if (this.mouse.getState() == 2) {
            this.mouse.setState(0);
        }
        for (KeyCode key : KeyCode.values()) {
            if (this.keyboard.get((Object)key) != 2) continue;
            this.keyboard.put(key, 0);
        }
        this.mouseEventQueue.forEach(this::processMouseEvent);
        this.mouseEventQueue.clear();
        this.keyEventQueue.forEach(this::processKeyEvent);
        this.keyEventQueue.clear();
    }

    private void processMouseEvent(MouseEvent event) {
        float canvasX = this.canvas.toCanvasX((int)event.getSceneX());
        float canvasY = this.canvas.toCanvasY((int)event.getSceneY());
        this.mouse.setPosition(new Point2D(canvasX, canvasY));
        if (event.getEventType() == MouseEvent.MOUSE_RELEASED) {
            this.mouse.setState(2);
        } else if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.mouse.setState(1);
        }
    }

    private void processKeyEvent(KeyEvent event) {
        KeyCode keyCode = KEY_CODES.get(event.getCode().getCode());
        if (keyCode != null) {
            if (event.getEventType() == KeyEvent.KEY_RELEASED) {
                this.keyboard.put(keyCode, 2);
            } else if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                this.keyboard.put(keyCode, 1);
            }
        }
    }

    @Override
    public Iterable<Pointer> getPointers() {
        return List.of(this.mouse);
    }

    @Override
    public void clearPointerState() {
        this.mouse.setState(0);
    }

    @Override
    public boolean isTouchAvailable() {
        return false;
    }

    @Override
    public boolean isKeyboardAvailable() {
        return true;
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        return this.keyboard.get((Object)keyCode) == 1;
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        return this.keyboard.get((Object)keyCode) == 2;
    }

    @Override
    public String requestTextInput(String labelText, String initialValue) {
        JLabel label = new JLabel(labelText);
        JTextField field = new JTextField(initialValue);
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.add((Component)label, "North");
        panel.add((Component)field, "Center");
        SwingUtils.setPreferredWidth((JComponent)panel, (int)300);
        Popups.message(null, (String)"", (JComponent)panel);
        return field.getText();
    }

    @Override
    public void fillClipboard(String text) {
        SwingUtils.copyToClipboard((String)text);
    }
}

