/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.jfx;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.image.Image;
import javafx.scene.media.Media;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.multimedialib.renderer.jfx.JFXAudioPlayer;
import nl.colorize.multimedialib.renderer.jfx.JFXImage;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.stats.Cache;

public class JFXMediaLoader
extends StandardMediaLoader {
    private Map<String, Font> loadedFontFamilies = new HashMap<String, Font>();
    private Cache<FontFace, Font> fontCache = Cache.from(this::loadFont);

    @Override
    public JFXImage loadImage(FilePointer file) {
        JFXImage jFXImage;
        block8: {
            ResourceFile source = this.locateFile(file);
            InputStream stream = source.openStream();
            try {
                Image fxImage = new Image(stream);
                Region region = new Region(0, 0, (int)fxImage.getWidth(), (int)fxImage.getHeight());
                jFXImage = new JFXImage(fxImage, region);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MediaException("Could not load image: " + String.valueOf(file), e);
                }
            }
            stream.close();
        }
        return jFXImage;
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        ClassLoader classLoader = JFXMediaLoader.class.getClassLoader();
        URL resourceURL = classLoader.getResource(file.path());
        if (resourceURL == null) {
            throw new MediaException("Cannot locate media file: " + String.valueOf(file));
        }
        Media media = new Media(resourceURL.toString());
        return new JFXAudioPlayer(media);
    }

    @Override
    public FontFace loadFont(FilePointer file, String family, FontStyle style) {
        FontFace font = new FontFace(this, file, family, style);
        this.getFont(font);
        return font;
    }

    private Font loadFont(FontFace key) {
        Font family = this.loadedFontFamilies.get(key.family());
        ResourceFile source = this.locateFile(key.origin());
        if (family == null) {
            try (InputStream stream = source.openStream();){
                family = Font.loadFont((InputStream)stream, (double)12.0);
                this.loadedFontFamilies.put(key.family(), family);
            }
            catch (IOException e) {
                throw new MediaException("Could not load font: " + String.valueOf(key.origin()), e);
            }
        }
        FontWeight weight = key.style().bold() ? FontWeight.BOLD : FontWeight.NORMAL;
        return Font.font((String)family.getFamily(), (FontWeight)weight, (double)key.style().size());
    }

    protected Font getFont(FontFace key) {
        return (Font)this.fontCache.get((Object)key);
    }
}

