/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.jfx;

import com.google.common.base.Preconditions;
import java.util.logging.Logger;
import javafx.application.Application;
import javax.swing.SwingUtilities;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.StandardNetwork;
import nl.colorize.multimedialib.renderer.jfx.JFXAnimationLoop;
import nl.colorize.multimedialib.renderer.jfx.JFXGraphics;
import nl.colorize.multimedialib.renderer.jfx.JFXInput;
import nl.colorize.multimedialib.renderer.jfx.JFXMediaLoader;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.util.LogHelper;
import nl.colorize.util.swing.SwingUtils;

public class JFXRenderer
implements Renderer {
    private GraphicsMode graphicsMode = GraphicsMode.MODE_2D;
    private DisplayMode displayMode;
    private WindowOptions windowOptions;
    private JFXGraphics graphics;
    private JFXInput input;
    private JFXMediaLoader mediaLoader;
    private Network network;
    private SceneContext context;
    private ErrorHandler errorHandler;
    private static JFXRenderer instance;
    private static final Logger LOGGER;

    private JFXRenderer(DisplayMode displayMode, WindowOptions windowOptions) {
        this.displayMode = displayMode;
        this.windowOptions = windowOptions;
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        SwingUtilities.invokeLater(SwingUtils::initializeSwing);
        this.mediaLoader = new JFXMediaLoader();
        this.network = new StandardNetwork();
        this.input = new JFXInput(this.displayMode.canvas());
        this.graphics = new JFXGraphics(this.displayMode, this.mediaLoader);
        this.context = new SceneContext(this, this.mediaLoader, this.input, this.network);
        this.context.changeScene(initialScene);
        this.errorHandler = errorHandler;
        Application.launch(JFXAnimationLoop.class, (String[])new String[0]);
    }

    @Override
    public void terminate() {
        System.exit(0);
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.MODE_2D;
    }

    public String toString() {
        return "JavaFX renderer";
    }

    public static synchronized JFXRenderer launch(DisplayMode displayMode, WindowOptions windowOptions) {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Another JFXRenderer instance is already active");
        instance = new JFXRenderer(displayMode, windowOptions);
        return instance;
    }

    protected static synchronized JFXRenderer accessInstance() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"JFXRenderer has not yet been initialized");
        Preconditions.checkState((JFXRenderer.instance.context != null ? 1 : 0) != 0, (Object)"Scene context not yet initialized");
        return instance;
    }

    public WindowOptions getWindowOptions() {
        return this.windowOptions;
    }

    public JFXGraphics getGraphics() {
        return this.graphics;
    }

    public JFXInput getInput() {
        return this.input;
    }

    public JFXMediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    public Network getNetwork() {
        return this.network;
    }

    public SceneContext getContext() {
        return this.context;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    static {
        LOGGER = LogHelper.getLogger(JFXRenderer.class);
    }
}

