/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.PolygonModel;

public class GDXGeometryBuilder
implements GeometryBuilder {
    private GDXMediaLoader media;

    protected GDXGeometryBuilder(GDXMediaLoader media) {
        this.media = media;
    }

    @Override
    public PolygonModel createQuad(Point2D size, ColorRGB color) {
        return this.createBox(new Point3D(size.x(), 0.001f, size.y()), color);
    }

    @Override
    public PolygonModel createQuad(Point2D size, Image texture) {
        return this.createBox(new Point3D(size.x(), 0.001f, size.y()), texture);
    }

    @Override
    public PolygonModel createBox(Point3D size, ColorRGB color) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createBox(size.x(), size.y(), size.z(), this.createMaterial(color), 9L);
        return this.media.createInstance(model);
    }

    @Override
    public PolygonModel createBox(Point3D size, Image texture) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createBox(size.x(), size.y(), size.z(), this.createMaterial((GDXImage)texture), 25L);
        return this.media.createInstance(model);
    }

    @Override
    public PolygonModel createSphere(float diameter, ColorRGB color) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createSphere(diameter, diameter, diameter, 32, 32, this.createMaterial(color), 9L);
        return this.media.createInstance(model);
    }

    @Override
    public PolygonModel createSphere(float diameter, Image texture) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createSphere(diameter, diameter, diameter, 32, 32, this.createMaterial((GDXImage)texture), 25L);
        return this.media.createInstance(model);
    }

    private Material createMaterial(ColorRGB color) {
        ColorAttribute colorAttr = ColorAttribute.createDiffuse((Color)GDXMediaLoader.toColor(color));
        return new Material(new Attribute[]{colorAttr});
    }

    private Material createMaterial(GDXImage texture) {
        TextureAttribute colorAttr = TextureAttribute.createDiffuse((TextureRegion)texture.getTextureRegion());
        return new Material(new Attribute[]{colorAttr});
    }
}

