/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.stage.ModelAnimation;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.multimedialib.stage.Transform3D;

public class GDXModel
implements PolygonModel {
    private ModelInstance instance;
    private Transform3D transform;
    private Map<String, Animation> animations;
    private AnimationController animationController;

    protected GDXModel(ModelInstance instance) {
        this.instance = instance;
        this.transform = new Transform3D();
        this.animations = new HashMap<String, Animation>();
        for (Animation anim : instance.model.animations) {
            this.animations.put(anim.id, anim);
        }
    }

    protected ModelInstance getInstance() {
        return this.instance;
    }

    @Override
    public void update(float deltaTime) {
        this.instance.transform.setToTranslation(this.transform.getPosition().x(), this.transform.getPosition().y(), this.transform.getPosition().z());
        this.instance.transform.rotate(1.0f, 0.0f, 0.0f, this.transform.getRotationX());
        this.instance.transform.rotate(0.0f, 1.0f, 0.0f, this.transform.getRotationY());
        this.instance.transform.rotate(0.0f, 0.0f, 1.0f, this.transform.getRotationZ());
        this.instance.transform.scale(this.transform.getScaleX(), this.transform.getScaleY(), this.transform.getScaleZ());
        if (this.animationController != null) {
            this.animationController.update(deltaTime);
            if (this.isAnimationCompleted()) {
                this.animationController = null;
            }
        }
    }

    @Override
    public ModelAnimation getAnimation(String name) {
        Animation animation = this.animations.get(name);
        Preconditions.checkArgument((animation != null ? 1 : 0) != 0, (Object)("No such animation: " + name));
        return new ModelAnimation(name, animation.duration, false);
    }

    @Override
    public void playAnimation(ModelAnimation animation) {
        int loopCount = animation.loop() ? Integer.MAX_VALUE : 1;
        this.animationController = new AnimationController(this.instance);
        this.animationController.animate(animation.name(), loopCount, 1.0f, null, 0.0f);
    }

    private boolean isAnimationCompleted() {
        return this.animationController == null || this.animationController.current == null || this.animationController.current.loopCount == 0;
    }

    @Override
    public Transform3D getTransform() {
        return this.transform;
    }

    @Override
    public PolygonModel copy() {
        ModelInstance instanceCopy = new ModelInstance(this.instance.model);
        return new GDXModel(instanceCopy);
    }

    public String toString() {
        return "GDXModel";
    }
}

