/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.utils.GdxNativesLoader;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.awt.Dimension;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.RendererException;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.StandardNetwork;
import nl.colorize.multimedialib.renderer.libgdx.GDXGraphics;
import nl.colorize.multimedialib.renderer.libgdx.GDXInput;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.TextUtils;
import nl.colorize.util.swing.SwingUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.Configuration;

public class GDXRenderer
implements Renderer,
ApplicationListener {
    private GraphicsMode graphicsMode;
    private Canvas canvas;
    private int framerate;
    private WindowOptions window;
    private GDXGraphics graphicsContext;
    private GDXInput input;
    private GDXMediaLoader mediaLoader;
    private Network network;
    private SceneContext context;
    private Scene initialScene;
    private static AtomicBoolean nativeLibrariesLoaded = new AtomicBoolean(false);
    private static final List<NativeLibrary> NATIVE_LIBRARIES = List.of(new NativeLibrary("gdx", "libgdx64.dylib"), new NativeLibrary("lwjgl", "liblwjgl.dylib"), new NativeLibrary("lwjgl_opengl", "liblwjgl_opengl.dylib"), new NativeLibrary("lwjgl_stb", "liblwjgl_stb.dylib"), new NativeLibrary("glfw", "libglfw.dylib"), new NativeLibrary("openal", "libopenal.dylib"), new NativeLibrary("gdx-freetype", "libgdx-freetype64.dylib"));
    private static final Logger LOGGER = LogHelper.getLogger(GDXRenderer.class);

    public GDXRenderer(GraphicsMode graphicsMode, DisplayMode displayMode, WindowOptions window) {
        this.graphicsMode = graphicsMode;
        this.canvas = displayMode.canvas();
        this.framerate = displayMode.framerate();
        this.window = window;
        if (Platform.isMacAppStore() && !nativeLibrariesLoaded.get()) {
            try {
                nativeLibrariesLoaded.set(true);
                this.loadApplicationBundleNativeLibraries();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while loading libGDX native libraries", e);
            }
        }
    }

    private void loadApplicationBundleNativeLibraries() throws Exception {
        LOGGER.info("Loading native libraries from Mac application bundle");
        LOGGER.info("Native library path: " + System.getProperty("java.library.path"));
        File nativeLibraryDir = Platform.getNativeLibraryPath().stream().filter(dir -> dir.getName().equalsIgnoreCase("MacOS")).findFirst().orElseThrow(() -> new RendererException("Cannot locate native libraries"));
        Function<String, String> lwjglMapper = lib -> this.locateNativeLWJGL((String)lib, nativeLibraryDir);
        Configuration.LIBRARY_PATH.set((Object)nativeLibraryDir.getAbsolutePath());
        Configuration.BUNDLED_LIBRARY_PATH_MAPPER.set(lwjglMapper);
        Configuration.BUNDLED_LIBRARY_NAME_MAPPER.set(lwjglMapper);
        Configuration.GLFW_LIBRARY_NAME.set((Object)lwjglMapper.apply("glfw"));
        this.initGLFW();
        GdxNativesLoader.disableNativesLoading = true;
        for (NativeLibrary lib2 : NATIVE_LIBRARIES) {
            SharedLibraryLoader.setLoaded((String)lib2.name);
            File dylib = new File(nativeLibraryDir, lib2.fileName);
            LOGGER.info("Loading native library " + lib2.name + " from " + dylib.getAbsolutePath());
            System.load(dylib.getAbsolutePath());
        }
    }

    private String locateNativeLWJGL(String lib, File nativeLibraryDir) {
        if (TextUtils.startsWith((String)(lib = lib.substring(lib.lastIndexOf("/") + 1)), List.of("lwjgl", "glfw", "openal"))) {
            lib = TextUtils.addLeading((String)lib, (String)"lib");
        }
        lib = TextUtils.addTrailing((String)lib, (String)".dylib");
        File dylib = new File(nativeLibraryDir, lib);
        LOGGER.info("Loading native LWJGL library " + dylib.getAbsolutePath());
        return dylib.getAbsolutePath();
    }

    @Deprecated
    private void initGLFW() throws Exception {
        Field errorCallback = Lwjgl3Application.class.getDeclaredField("errorCallback");
        errorCallback.setAccessible(true);
        errorCallback.set(null, GLFWErrorCallback.createPrint((PrintStream)Lwjgl3ApplicationConfiguration.errorStream));
        Method awtInit = Lwjgl3Application.class.getDeclaredMethod("loadGlfwAwtMacos", new Class[0]);
        awtInit.setAccessible(true);
        awtInit.invoke(null, new Object[0]);
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)((GLFWErrorCallbackI)errorCallback.get(null)));
        GLFW.glfwInitHint((int)327682, (int)225288);
        GLFW.glfwInitHint((int)327681, (int)0);
        if (!GLFW.glfwInit()) {
            throw new RendererException("Error while initializing GLFW");
        }
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        this.initialScene = initialScene;
        try {
            Lwjgl3ApplicationConfiguration config = this.configure();
            new Lwjgl3Application((ApplicationListener)this, config);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error during animation loop", e);
            errorHandler.onError(this.context, e);
        }
    }

    private Lwjgl3ApplicationConfiguration configure() {
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setIdleFPS(this.framerate);
        config.setForegroundFPS(this.framerate);
        config.setHdpiMode(HdpiMode.Logical);
        config.setTitle(this.window.getTitle());
        config.setWindowIcon(Files.FileType.Internal, new String[]{this.window.getIconFile().path()});
        config.setDecorated(true);
        this.configureDisplayMode(config);
        return config;
    }

    private void configureDisplayMode(Lwjgl3ApplicationConfiguration config) {
        if (this.window.isFullscreen()) {
            this.configureFullScreen(config);
        } else {
            this.configureWindow(config);
        }
    }

    private void configureFullScreen(Lwjgl3ApplicationConfiguration config) {
        if (Platform.isMac()) {
            Dimension screen = SwingUtils.getScreenSize();
            config.setDecorated(false);
            config.setWindowedMode(screen.width, screen.height);
            config.setMaximized(true);
        } else {
            config.setFullscreenMode(Lwjgl3ApplicationConfiguration.getDisplayMode());
        }
    }

    private void configureWindow(Lwjgl3ApplicationConfiguration config) {
        int width = this.canvas.getWidth();
        int height = this.canvas.getHeight();
        if (Platform.isWindows()) {
            float uiScale = SwingUtils.getDesktopScaleFactor();
            config.setWindowedMode(Math.round((float)width * uiScale), Math.round((float)height * uiScale));
        } else {
            config.setWindowedMode(width, height);
        }
    }

    public void create() {
        this.input = new GDXInput(this.canvas);
        this.mediaLoader = new GDXMediaLoader();
        this.graphicsContext = new GDXGraphics(this.canvas, this.mediaLoader);
        this.network = new StandardNetwork();
        this.resize(this.canvas.getWidth(), this.canvas.getHeight());
        this.context = new SceneContext(this, this.mediaLoader, this.input, this.network);
        this.context.changeScene(this.initialScene);
    }

    public void dispose() {
        this.graphicsContext.dispose();
        this.mediaLoader.dispose();
    }

    public void resize(int width, int height) {
        this.canvas.resizeScreen(width, height);
        HdpiUtils.glViewport((int)0, (int)0, (int)width, (int)height);
        this.graphicsContext.restartBatch();
    }

    public void pause() {
    }

    public void resume() {
    }

    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16640);
        this.context.syncFrame();
        this.renderStage(this.context.getStage());
        this.graphicsContext.switchMode(false, false);
    }

    private void renderStage(Stage stage) {
        this.context.getFrameStats().markStart("$$frameRender");
        if (this.graphicsMode == GraphicsMode.MODE_3D) {
            this.graphicsContext.render3D(stage.getWorld());
        }
        stage.visit(this.graphicsContext, this.context.getSceneTime());
        this.context.getFrameStats().markEnd("$$frameRender");
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return this.graphicsMode;
    }

    @Override
    public DisplayMode getDisplayMode() {
        return new DisplayMode(this.canvas, this.framerate);
    }

    @Override
    public void terminate() {
        System.exit(0);
    }

    public String toString() {
        return "libGDX renderer";
    }

    private record NativeLibrary(String name, String fileName) {
    }
}

