/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.pixi;

import com.google.common.base.Preconditions;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.RendererException;
import nl.colorize.multimedialib.renderer.pixi.Pixi;
import nl.colorize.multimedialib.renderer.pixi.PixiBridge;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.BrowserDOM;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.LogHelper;
import nl.colorize.util.TextUtils;
import nl.colorize.util.stats.Cache;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLImageElement;

public class PixiGraphics
implements TeaGraphics {
    private Canvas canvas;
    private BrowserDOM dom;
    private PixiBridge pixi;
    private Map<UUID, Pixi.DisplayObject> displayObjects;
    private Cache<TeaImage, Pixi.Texture> textureCache;
    private static final int TEXTURE_CACHE_SIZE = 2048;
    private static final Logger LOGGER = LogHelper.getLogger(PixiGraphics.class);

    public PixiGraphics(Canvas canvas) {
        this.canvas = canvas;
        this.dom = new BrowserDOM();
        this.pixi = Browser.getPixiBridge();
        this.displayObjects = new HashMap<UUID, Pixi.DisplayObject>();
        this.textureCache = Cache.from(this::prepareTexture, (int)2048);
    }

    @Override
    public void init(TeaMediaLoader mediaLoader) {
        this.pixi.init();
    }

    private Pixi.Rectangle getScreen() {
        return this.pixi.getPixiApp().getScreen();
    }

    @Override
    public int getDisplayWidth() {
        return Math.round(this.getScreen().getWidth());
    }

    @Override
    public int getDisplayHeight() {
        return Math.round(this.getScreen().getHeight());
    }

    @Override
    public float getDevicePixelRatio() {
        return 1.0f;
    }

    @Override
    public void prepareStage(Stage stage) {
        Container rootContainer = stage.getRoot();
        this.displayObjects.putIfAbsent(rootContainer.getLocation().getId(), this.pixi.getRootContainer());
    }

    @Override
    public void visitContainer(Container container) {
        Pixi.DisplayObject parent = this.displayObjects.get(container.getLocation().getId());
        parent.setVisible(container.getTransform().isVisible());
        for (Graphic2D added : container.getLocation().getAddedChildren().flush()) {
            this.onGraphicAdded(parent, added);
        }
        for (Graphic2D removed : container.getLocation().getRemovedChildren().flush()) {
            this.onGraphicRemoved(parent, removed);
        }
    }

    private void onGraphicAdded(Pixi.DisplayObject parent, Graphic2D added) {
        if (!this.displayObjects.containsKey(added.getLocation().getId())) {
            Pixi.DisplayObject displayObject = this.createDisplayObject(added);
            parent.addChild(displayObject);
            this.displayObjects.put(added.getLocation().getId(), displayObject);
        }
    }

    private void onGraphicRemoved(Pixi.DisplayObject parent, Graphic2D removed) {
        if (this.displayObjects.containsKey(removed.getLocation().getId())) {
            parent.removeChild(this.getDisplayObject(removed));
            this.displayObjects.remove(removed.getLocation().getId());
        }
    }

    @Override
    public boolean shouldVisitAllGraphics() {
        return true;
    }

    private Pixi.DisplayObject createDisplayObject(Graphic2D graphic) {
        Graphic2D graphic2D = graphic;
        Objects.requireNonNull(graphic2D);
        Graphic2D graphic2D2 = graphic2D;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Container.class, Sprite.class, Primitive.class, Text.class}, (Object)graphic2D2, n)) {
            case 0 -> {
                Container container = (Container)graphic2D2;
                yield this.pixi.createContainer();
            }
            case 1 -> {
                Sprite sprite = (Sprite)graphic2D2;
                yield this.createSpriteDisplayObject(sprite);
            }
            case 2 -> {
                Primitive primitive = (Primitive)graphic2D2;
                yield this.pixi.createGraphics();
            }
            case 3 -> {
                Text text = (Text)graphic2D2;
                yield this.createTextDisplayObject(text);
            }
            default -> throw new RendererException("Unknown graphics type: " + String.valueOf(graphic));
        };
    }

    private Pixi.DisplayObject createSpriteDisplayObject(Sprite sprite) {
        TeaImage image = this.getImage(sprite);
        Pixi.DisplayObject spriteContainer = this.pixi.createContainer();
        image.getImagePromise().subscribe(imageElement -> {
            Pixi.Texture texture = (Pixi.Texture)this.textureCache.get((Object)image);
            Pixi.DisplayObject spriteDisplayObject = this.pixi.createSprite(texture);
            spriteContainer.addChild(spriteDisplayObject);
        });
        return spriteContainer;
    }

    private Pixi.DisplayObject createTextDisplayObject(Text text) {
        String family = text.getFont().family();
        FontStyle style = text.getFont().scale(this.canvas).style();
        return this.pixi.createText(family, style.size(), style.bold(), text.getAlign().toString(), text.getLineHeight(), style.color().getRGB());
    }

    private TeaImage getImage(Sprite sprite) {
        return (TeaImage)sprite.getCurrentGraphics();
    }

    private Pixi.Texture prepareTexture(TeaImage image) {
        Preconditions.checkState((boolean)image.isLoaded(), (Object)"Image is still loading");
        HTMLImageElement imgElement = image.getImageElement().get();
        Region region = image.getRegion();
        return this.pixi.createTexture(image.getId().toString(), (CanvasImageSource)imgElement, region.x(), region.y(), region.width(), region.height());
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.pixi.changeBackgroundColor(color.getRGB());
    }

    private Pixi.DisplayObject getDisplayObject(Graphic2D graphic) {
        Pixi.DisplayObject displayObject = this.displayObjects.get(graphic.getLocation().getId());
        if (displayObject == null) {
            throw new RendererException("Creating unexpected display object for " + String.valueOf(graphic));
        }
        displayObject.setVisible(graphic.getTransform().isVisible());
        return displayObject;
    }

    @Override
    public void drawSprite(Sprite sprite) {
        Pixi.DisplayObject displayObject = this.getDisplayObject(sprite);
        Pixi.DisplayObject[] containerContents = displayObject.getChildren();
        if (containerContents.length == 0) {
            return;
        }
        Pixi.DisplayObject spriteDisplayObject = containerContents[0];
        this.updateSprite(sprite, spriteDisplayObject);
    }

    private void updateSprite(Sprite sprite, Pixi.DisplayObject displayObject) {
        TeaImage image = this.getImage(sprite);
        Transform transform = sprite.getGlobalTransform();
        float zoom = this.canvas.getZoomLevel();
        displayObject.setX(this.toScreenX(transform.getPosition()));
        displayObject.setY(this.toScreenY(transform.getPosition()));
        displayObject.setAlpha(transform.getAlpha() / 100.0f);
        displayObject.setAngle(transform.getRotation().degrees());
        displayObject.getScale().setX(transform.getScaleX() * zoom / 100.0f);
        displayObject.getScale().setY(transform.getScaleY() * zoom / 100.0f);
        if (!displayObject.isTintEnabled()) {
            this.updateTexture(displayObject, image);
        }
        this.updateTextureRegion(displayObject, image.getRegion());
        this.updateMask(displayObject, image, transform.getMaskColor());
    }

    private void updateTexture(Pixi.DisplayObject sprite, TeaImage image) {
        Pixi.Texture texture = sprite.getTexture();
        if (!image.getId().toString().equals(texture.getTextureImageId())) {
            Pixi.Texture newTexture = (Pixi.Texture)this.textureCache.get((Object)image);
            sprite.setTexture(newTexture);
        }
    }

    private void updateTextureRegion(Pixi.DisplayObject sprite, Region region) {
        Pixi.Texture texture = sprite.getTexture();
        Pixi.Rectangle frame = texture.getFrame();
        frame.setX(region.x());
        frame.setY(region.y());
        frame.setWidth(region.width());
        frame.setHeight(region.height());
        texture.updateUvs();
    }

    private void updateMask(Pixi.DisplayObject sprite, TeaImage image, ColorRGB mask) {
        if (!sprite.isTintEnabled() && mask != null) {
            HTMLCanvasElement maskImage = this.dom.applyMask(image, mask);
            Region region = image.getRegion();
            UUID maskImageId = UUID.randomUUID();
            Pixi.Texture maskTexture = this.pixi.createTexture(maskImageId.toString(), (CanvasImageSource)maskImage, region.x(), region.y(), region.width(), region.height());
            sprite.setTintEnabled(true);
            sprite.setOriginalTexture(sprite.getTexture());
            sprite.setTexture(maskTexture);
        } else if (sprite.isTintEnabled() && mask == null) {
            sprite.setTintEnabled(false);
            sprite.setTexture(sprite.getOriginalTexture());
        }
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        Pixi.DisplayObject displayObject = this.getDisplayObject(graphic);
        Transform transform = graphic.getGlobalTransform();
        displayObject.clear();
        displayObject.lineStyle(Math.round(graphic.getStroke()), graphic.getColor().getRGB());
        displayObject.moveTo(this.toScreenX(line.start()), this.toScreenY(line.start()));
        displayObject.lineTo(this.toScreenX(line.end()), this.toScreenY(line.end()));
        displayObject.setAlpha(transform.getAlpha() / 100.0f);
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line) {
        Pixi.DisplayObject displayObject = this.getDisplayObject(graphic);
        Transform transform = graphic.getGlobalTransform();
        displayObject.clear();
        displayObject.lineStyle(Math.round(graphic.getStroke()), graphic.getColor().getRGB());
        displayObject.moveTo(this.toScreenX(line.getHead()), this.toScreenY(line.getHead()));
        for (Point2D p : line.points()) {
            displayObject.lineTo(this.toScreenX(p), this.toScreenY(p));
        }
        displayObject.setAlpha(transform.getAlpha() / 100.0f);
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        Pixi.DisplayObject displayObject = this.getDisplayObject(graphic);
        Transform transform = graphic.getGlobalTransform();
        displayObject.clear();
        displayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        displayObject.drawRect(this.toScreenX(rect.x()), this.toScreenY(rect.y()), rect.width() * this.canvas.getZoomLevel(), rect.height() * this.canvas.getZoomLevel());
        displayObject.endFill();
        displayObject.setAlpha(transform.getAlpha() / 100.0f);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        Pixi.DisplayObject displayObject = this.getDisplayObject(graphic);
        Transform transform = graphic.getGlobalTransform();
        displayObject.clear();
        displayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        displayObject.drawCircle(this.toScreenX(circle.center().x()), this.toScreenY(circle.center().y()), circle.radius() * this.canvas.getZoomLevel());
        displayObject.endFill();
        displayObject.setAlpha(transform.getAlpha() / 100.0f);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        Pixi.DisplayObject displayObject = this.getDisplayObject(graphic);
        Transform transform = graphic.getGlobalTransform();
        float[] points = new float[polygon.getNumPoints() * 2];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            points[i * 2] = this.toScreenX(polygon.getPointX(i));
            points[i * 2 + 1] = this.toScreenY(polygon.getPointY(i));
        }
        displayObject.clear();
        displayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        displayObject.drawPolygon(points);
        displayObject.endFill();
        displayObject.setAlpha(transform.getAlpha() / 100.0f);
    }

    @Override
    public void drawText(Text text) {
        Pixi.DisplayObject displayObject = this.getDisplayObject(text);
        Transform transform = text.getGlobalTransform();
        float offset = -0.65f * text.getLineHeight();
        displayObject.setText(TextUtils.LINE_JOINER.join(text.getLines()));
        displayObject.setX(this.toScreenX(transform.getPosition()));
        displayObject.setY(this.toScreenY(transform.getPosition().y() + offset));
        displayObject.setAlpha(transform.getAlpha() / 100.0f);
    }

    private float toScreenX(float x) {
        return this.canvas.toScreenX(x);
    }

    private float toScreenX(Point2D point) {
        return this.canvas.toScreenX(point.x());
    }

    private float toScreenY(float y) {
        return this.canvas.toScreenY(y);
    }

    private float toScreenY(Point2D point) {
        return this.canvas.toScreenY(point.y());
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.MODE_2D;
    }
}

