/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.teavm.BrowserDOM;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import org.teavm.jso.browser.Window;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;

public class HtmlCanvasGraphics
implements TeaGraphics {
    private Canvas sceneCanvas;
    private BrowserDOM dom;
    private HTMLCanvasElement htmlCanvas;
    private CanvasRenderingContext2D context;

    public HtmlCanvasGraphics(Canvas sceneCanvas) {
        this.sceneCanvas = sceneCanvas;
        this.dom = new BrowserDOM();
    }

    @Override
    public void init(TeaMediaLoader mediaLoader) {
        HTMLDocument document = Window.current().getDocument();
        HTMLElement container = document.getElementById("multimediaLibContainer");
        this.htmlCanvas = this.dom.createFullScreenCanvas(container);
        this.context = (CanvasRenderingContext2D)this.htmlCanvas.getContext("2d");
    }

    @Override
    public int getDisplayWidth() {
        return this.htmlCanvas.getWidth();
    }

    @Override
    public int getDisplayHeight() {
        return this.htmlCanvas.getHeight();
    }

    @Override
    public boolean shouldVisitAllGraphics() {
        return false;
    }

    @Override
    public void visitContainer(Container container) {
    }

    @Override
    public void prepareStage(Stage stage) {
        this.context.clearRect(0.0, 0.0, (double)this.htmlCanvas.getWidth(), (double)this.htmlCanvas.getHeight());
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.context.setFillStyle(color.toHex());
        this.context.fillRect(0.0, 0.0, (double)this.htmlCanvas.getWidth(), (double)this.htmlCanvas.getHeight());
    }

    @Override
    public void drawSprite(Sprite sprite) {
        TeaImage teaImage = (TeaImage)sprite.getCurrentGraphics();
        if ((float)teaImage.getWidth() > 0.0f && (float)teaImage.getHeight() > 0.0f) {
            this.drawImage(teaImage, teaImage.getRegion(), sprite.getGlobalTransform());
        }
    }

    private void drawImage(TeaImage image, Region region, Transform transform) {
        CanvasImageSource source = this.prepareImage(image, transform.getMaskColor());
        Point2D position = transform.getPosition();
        if (source == null) {
            return;
        }
        this.context.setGlobalAlpha((double)(transform.getAlpha() / 100.0f));
        this.context.translate((double)this.toScreenX(position), (double)this.toScreenY(position));
        this.context.rotate((double)transform.getRotation().degrees() * Math.PI / 180.0);
        this.context.scale((double)(transform.getScaleX() * this.sceneCanvas.getZoomLevel() / 100.0f), (double)(transform.getScaleY() * this.sceneCanvas.getZoomLevel() / 100.0f));
        this.context.drawImage(source, (double)region.x(), (double)region.y(), (double)region.width(), (double)region.height(), (double)((float)(-region.width()) / 2.0f), (double)((float)(-region.height()) / 2.0f), (double)region.width(), (double)region.height());
        this.context.setGlobalAlpha(1.0);
        this.context.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    private CanvasImageSource prepareImage(TeaImage image, ColorRGB mask) {
        if (!image.isLoaded()) {
            return null;
        }
        if (mask == null) {
            return image.getImageElement().orElse(null);
        }
        return this.dom.applyMask(image, mask);
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        this.context.setStrokeStyle(graphic.getColor().toHex());
        this.context.setLineWidth((double)graphic.getStroke());
        this.context.beginPath();
        this.context.moveTo((double)this.toScreenX(line.start()), (double)this.toScreenY(line.start()));
        this.context.lineTo((double)this.toScreenX(line.end()), (double)this.toScreenY(line.end()));
        this.context.stroke();
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line) {
        this.context.setStrokeStyle(graphic.getColor().toHex());
        this.context.setLineWidth((double)graphic.getStroke());
        this.context.beginPath();
        this.context.moveTo((double)this.toScreenX(line.getHead()), (double)this.toScreenY(line.getHead()));
        for (Point2D p : line.points()) {
            this.context.lineTo((double)this.toScreenX(p), (double)this.toScreenY(p));
        }
        this.context.stroke();
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        Transform transform = graphic.getGlobalTransform();
        this.context.setGlobalAlpha((double)(transform.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.fillRect((double)this.toScreenX(rect.x()), (double)this.toScreenY(rect.y()), (double)(rect.width() * this.sceneCanvas.getZoomLevel()), (double)(rect.height() * this.sceneCanvas.getZoomLevel()));
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        Transform transform = graphic.getGlobalTransform();
        this.context.setGlobalAlpha((double)(transform.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.beginPath();
        this.context.arc((double)this.toScreenX(circle.center().x()), (double)this.toScreenY(circle.center().y()), (double)(circle.radius() * this.sceneCanvas.getZoomLevel()), 0.0, Math.PI * 2);
        this.context.fill();
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        Transform transform = graphic.getGlobalTransform();
        this.context.setGlobalAlpha((double)(transform.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.beginPath();
        this.context.moveTo((double)this.toScreenX(polygon.getPointX(0)), (double)this.toScreenY(polygon.getPointY(0)));
        for (int i = 1; i < polygon.getNumPoints(); ++i) {
            this.context.lineTo((double)this.toScreenX(polygon.getPointX(i)), (double)this.toScreenY(polygon.getPointY(i)));
        }
        this.context.fill();
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawText(Text text) {
        FontFace font = text.getFont().scale(this.sceneCanvas);
        Transform transform = text.getGlobalTransform();
        this.context.setGlobalAlpha((double)(transform.getAlpha() / 100.0f));
        this.context.setFont(this.getFontString(font));
        this.context.setFillStyle(font.style().color().toHex());
        this.context.setTextAlign(text.getAlign().toString().toLowerCase());
        text.forLines((i, line) -> {
            float y = this.toScreenY(transform.getPosition().y() + (float)i.intValue() * text.getLineHeight());
            this.context.fillText(line, (double)this.toScreenX(transform.getPosition()), (double)y);
        });
        this.context.setGlobalAlpha(1.0);
    }

    private String getFontString(FontFace font) {
        FontStyle style = font.style();
        return (style.bold() ? "bold " : "") + style.size() + "px " + font.family();
    }

    private float toScreenX(float x) {
        return this.sceneCanvas.toScreenX(x);
    }

    private float toScreenX(Point2D point) {
        return this.sceneCanvas.toScreenX(point.x());
    }

    private float toScreenY(float y) {
        return this.sceneCanvas.toScreenY(y);
    }

    private float toScreenY(Point2D point) {
        return this.sceneCanvas.toScreenY(point.y());
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.MODE_2D;
    }

    public HTMLCanvasElement getHtmlCanvas() {
        return this.htmlCanvas;
    }
}

