/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.math.Buffer;
import nl.colorize.multimedialib.renderer.PeerConnection;
import nl.colorize.multimedialib.renderer.teavm.MessageCallback;
import nl.colorize.multimedialib.renderer.teavm.PeerMessage;
import nl.colorize.multimedialib.renderer.teavm.PeerjsBridge;

public class PeerjsConnection
implements PeerConnection,
MessageCallback {
    private PeerjsBridge bridge;
    private Buffer<String> connectionQueue;
    private Buffer<PeerMessage> receivedBuffer;
    private List<String> sendHistory;

    protected PeerjsConnection(PeerjsBridge bridge) {
        this.bridge = bridge;
        this.connectionQueue = new Buffer();
        this.receivedBuffer = new Buffer();
        this.sendHistory = new ArrayList<String>();
        bridge.open(this);
    }

    @Override
    public void connect(String peerId) {
        this.connectionQueue.push(peerId);
        this.processConnectionQueue();
    }

    private void processConnectionQueue() {
        if (this.bridge.isInitialized()) {
            for (String peerId : this.connectionQueue.flush()) {
                this.bridge.connect(peerId, this);
            }
        }
    }

    @Override
    public void sendMessage(String message) {
        this.bridge.sendMessage(message);
        this.sendHistory.add(message);
    }

    @Override
    public Buffer<PeerMessage> getReceivedMessages() {
        return this.receivedBuffer;
    }

    @Override
    public void onMessage(String type, String value) {
        this.receivedBuffer.push(new PeerMessage(type, value));
        if (type.equals("init")) {
            this.processConnectionQueue();
        } else if (type.equals("connect")) {
            this.sendHistory.forEach(message -> this.bridge.sendMessageToPeer(value, (String)message));
        }
    }
}

