/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.util.Subscribable;
import org.teavm.jso.dom.html.HTMLAudioElement;

public class TeaAudio
implements Audio {
    private HTMLAudioElement audioElement;

    protected TeaAudio(Subscribable<HTMLAudioElement> audioPromise) {
        audioPromise.subscribe(event -> {
            this.audioElement = event;
        });
    }

    @Override
    public void play(int volume, boolean loop) {
        Preconditions.checkArgument((volume >= 0 && volume <= 100 ? 1 : 0) != 0, (Object)("Invalid volume: " + volume));
        if (this.audioElement != null) {
            this.audioElement.setVolume((float)volume / 100.0f);
            this.audioElement.setLoop(loop);
            this.audioElement.play();
        }
    }

    @Override
    public void stop() {
        if (this.audioElement != null) {
            this.audioElement.pause();
            this.audioElement.setCurrentTime(0.0);
        }
    }

    public String toString() {
        if (this.audioElement == null) {
            return "<loading>";
        }
        return this.audioElement.getSrc();
    }
}

