/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.UnsupportedGraphicsModeException;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaAudio;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.three.ThreeGraphics;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Subscribable;
import org.teavm.jso.browser.Storage;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.html.HTMLAudioElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLImageElement;

public class TeaMediaLoader
implements MediaLoader {
    private HTMLDocument document = Window.current().getDocument();
    private StageVisitor graphics;
    private List<FilePointer> manifest;
    private long timestamp;
    private static final FilePointer MANIFEST_FILE = new FilePointer("resource-file-manifest");
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n").trimResults().omitEmptyStrings();
    private static final Logger LOGGER = LogHelper.getLogger(TeaMediaLoader.class);

    protected TeaMediaLoader(StageVisitor graphics) {
        this.graphics = graphics;
        this.manifest = Collections.emptyList();
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public Image loadImage(FilePointer file) {
        HTMLImageElement imageElement = (HTMLImageElement)this.document.createElement("img");
        Subscribable imagePromise = new Subscribable();
        imageElement.setCrossOrigin("anonymous");
        imageElement.addEventListener("load", event -> imagePromise.next((Object)imageElement));
        imageElement.setSrc("resources/" + this.normalizeFilePath(file, false) + "?t=" + this.timestamp);
        return new TeaImage((Subscribable<HTMLImageElement>)imagePromise, null);
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        HTMLAudioElement audioElement = (HTMLAudioElement)this.document.createElement("audio");
        Subscribable audioPromise = new Subscribable();
        audioElement.setCrossOrigin("anonymous");
        audioElement.addEventListener("loadeddata", event -> audioPromise.next((Object)audioElement));
        audioElement.setSrc("resources/" + this.normalizeFilePath(file, false) + "?t=" + this.timestamp);
        return new TeaAudio((Subscribable<HTMLAudioElement>)audioPromise);
    }

    @Override
    public FontFace loadFont(FilePointer file, String family, FontStyle style) {
        String url = "url('resources/" + this.normalizeFilePath(file, false) + "')";
        Browser.preloadFontFace(family, url, error -> {
            if (error != null && !error.isEmpty()) {
                LOGGER.warning("Failed to load font '" + family + "': " + error);
            }
        });
        return new FontFace(this, file, family, style);
    }

    @Override
    public PolygonModel loadModel(FilePointer file) {
        StageVisitor stageVisitor = this.graphics;
        if (stageVisitor instanceof ThreeGraphics) {
            ThreeGraphics three = (ThreeGraphics)stageVisitor;
            throw new UnsupportedGraphicsModeException();
        }
        throw new UnsupportedGraphicsModeException();
    }

    @Override
    public GeometryBuilder getGeometryBuilder() {
        StageVisitor stageVisitor = this.graphics;
        if (stageVisitor instanceof ThreeGraphics) {
            ThreeGraphics three = (ThreeGraphics)stageVisitor;
            throw new UnsupportedGraphicsModeException();
        }
        throw new UnsupportedGraphicsModeException();
    }

    @Override
    public String loadText(FilePointer file) {
        HTMLElement resource = this.document.getElementById(this.normalizeFilePath(file, true));
        if (resource == null) {
            throw new MediaException("Unknown text resource file: " + String.valueOf(file));
        }
        return resource.getInnerText().trim();
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        String fileEntry = file.path().contains("/") ? file.path().substring(file.path().lastIndexOf("/") + 1) : file.path();
        return this.loadResourceFileManifest().stream().anyMatch(entry -> entry.path().equals(fileEntry));
    }

    private List<FilePointer> loadResourceFileManifest() {
        if (!this.manifest.isEmpty()) {
            return this.manifest;
        }
        this.manifest = LINE_SPLITTER.splitToList((CharSequence)this.loadText(MANIFEST_FILE)).stream().map(path -> new FilePointer((String)path)).toList();
        return this.manifest;
    }

    protected String normalizeFilePath(FilePointer file, boolean replaceDot) {
        String normalized = file.path();
        if (normalized.indexOf(47) != -1) {
            normalized = normalized.substring(normalized.lastIndexOf(47) + 1);
        }
        if (replaceDot) {
            normalized = normalized.replace(".", "_");
        }
        return normalized;
    }

    @Override
    public Properties loadApplicationData(String appName) {
        Storage localStorage = Browser.accessLocalStorage();
        Properties data = new Properties();
        if (localStorage != null) {
            for (int i = 0; i < localStorage.getLength(); ++i) {
                String name = localStorage.key(i);
                String value = localStorage.getItem(name);
                data.setProperty(name, value);
            }
        }
        return data;
    }

    @Override
    public void saveApplicationData(String appName, Properties data) {
        Storage localStorage = Browser.accessLocalStorage();
        if (localStorage != null) {
            for (String name : data.stringPropertyNames()) {
                localStorage.setItem(name, data.getProperty(name, ""));
            }
        }
    }
}

