/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.PeerConnection;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.PeerjsBridge;
import nl.colorize.multimedialib.renderer.teavm.PeerjsConnection;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Subscribable;
import nl.colorize.util.http.Headers;
import nl.colorize.util.http.PostData;
import nl.colorize.util.http.URLResponse;
import nl.colorize.util.stats.TupleList;
import org.teavm.jso.ajax.XMLHttpRequest;

public class TeaNetwork
implements Network {
    private static final Splitter HEADER_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n"));
    private static final Logger LOGGER = LogHelper.getLogger(TeaNetwork.class);

    @Override
    public Subscribable<URLResponse> get(String url, Headers headers) {
        XMLHttpRequest request = XMLHttpRequest.create();
        Subscribable subject = new Subscribable();
        request.setOnReadyStateChange(() -> this.handleResponse(request, (Subscribable<URLResponse>)subject));
        request.open("GET", url, true);
        this.addRequestHeaders(request, headers);
        request.send();
        return subject;
    }

    @Override
    public Subscribable<URLResponse> post(String url, Headers headers, PostData data) {
        XMLHttpRequest request = XMLHttpRequest.create();
        Subscribable subject = new Subscribable();
        request.setOnReadyStateChange(() -> this.handleResponse(request, (Subscribable<URLResponse>)subject));
        request.open("POST", url, true);
        this.addRequestHeaders(request, headers);
        request.send(data.encode(StandardCharsets.UTF_8));
        return subject;
    }

    private void addRequestHeaders(XMLHttpRequest request, Headers headers) {
        request.setRequestHeader("X-Requested-With", "MultimediaLib");
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((XMLHttpRequest)request).setRequestHeader(arg_0, arg_1));
        }
    }

    private void handleResponse(XMLHttpRequest request, Subscribable<URLResponse> subject) {
        if (request.getReadyState() == 4) {
            if (request.getStatus() >= 200 && request.getStatus() <= 204) {
                URLResponse response = this.parseResponse(request);
                subject.next((Object)response);
            } else {
                subject.nextError((Exception)new IOException("AJAX request failed: " + request.getStatusText()));
            }
        }
    }

    private URLResponse parseResponse(XMLHttpRequest request) {
        int status = request.getStatus();
        Headers headers = this.parseResponseHeaders(request);
        String body = request.getResponseText();
        return new URLResponse(status, headers, body.getBytes(StandardCharsets.UTF_8));
    }

    private Headers parseResponseHeaders(XMLHttpRequest request) {
        TupleList headers = new TupleList();
        for (String line : HEADER_SPLITTER.split((CharSequence)request.getAllResponseHeaders())) {
            if (line.contains(": ")) {
                String name = line.substring(0, line.indexOf(": "));
                String value = line.substring(line.indexOf(": ") + 2);
                headers.add((Object)name, (Object)value);
                continue;
            }
            if (line.isEmpty()) continue;
            LOGGER.warning("Malformed HTTP response header: " + line);
        }
        return new Headers(headers);
    }

    @Override
    public PeerConnection openPeerConnection() {
        PeerjsBridge bridge = Browser.getPeerJsBridge();
        return new PeerjsConnection(bridge);
    }

    @Override
    public boolean isPeerToPeerSupported() {
        return true;
    }
}

