/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.pixi.PixiGraphics;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.HtmlCanvasGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaInputDevice;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.renderer.teavm.TeaNetwork;
import nl.colorize.multimedialib.renderer.three.ThreeGraphics;
import nl.colorize.multimedialib.renderer.webgl.WebGL;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import org.teavm.jso.browser.Window;

public class TeaRenderer
implements Renderer {
    private DisplayMode displayMode;
    private TeaGraphics graphics;
    private TeaInputDevice inputDevice;
    private SceneContext context;

    private TeaRenderer(DisplayMode displayMode, TeaGraphics graphics) {
        this.displayMode = displayMode;
        this.graphics = graphics;
        this.inputDevice = new TeaInputDevice(displayMode.canvas(), graphics);
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        TeaMediaLoader mediaLoader = new TeaMediaLoader(this.graphics);
        TeaNetwork network = new TeaNetwork();
        this.inputDevice.bindEventHandlers();
        this.graphics.init(mediaLoader);
        this.context = new SceneContext(this, mediaLoader, this.inputDevice, network);
        this.context.changeScene(initialScene);
        Browser.prepareAnimationLoop();
        Browser.registerErrorHandler(error -> this.handleError(errorHandler, error));
        Window.requestAnimationFrame(this::onAnimationFrame);
    }

    private void onAnimationFrame(double timestamp) {
        if (this.prepareCanvas() && this.context.syncFrame() > 0) {
            this.renderFrame();
            this.inputDevice.reset();
        }
        Window.requestAnimationFrame(this::onAnimationFrame);
    }

    private boolean prepareCanvas() {
        int width = this.graphics.getDisplayWidth();
        int height = this.graphics.getDisplayHeight();
        if (width > 0 || height > 0) {
            this.displayMode.canvas().resizeScreen(width, height);
            return true;
        }
        return false;
    }

    private void renderFrame() {
        this.context.getFrameStats().markStart("$$frameRender");
        this.context.getStage().visit(this.graphics, this.context.getSceneTime());
        this.context.getFrameStats().markEnd("$$frameRender");
    }

    private void handleError(ErrorHandler errorHandler, String error) {
        RuntimeException cause = new RuntimeException("JavaScript error\n\n" + error);
        errorHandler.onError(this.context, cause);
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return this.graphics.getGraphicsMode();
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public void terminate() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.graphics instanceof HtmlCanvasGraphics) {
            return "HTML5 Canvas renderer";
        }
        if (this.graphics instanceof WebGL) {
            return "WebGL renderer";
        }
        if (this.graphics instanceof PixiGraphics) {
            return "Pixi.js renderer";
        }
        if (this.graphics instanceof ThreeGraphics) {
            return "Three.js renderer";
        }
        return "TeaVM renderer";
    }

    public static TeaRenderer withCanvas(DisplayMode displayMode) {
        HtmlCanvasGraphics graphics = new HtmlCanvasGraphics(displayMode.canvas());
        return new TeaRenderer(displayMode, graphics);
    }

    public static TeaRenderer withWebGL(GraphicsMode graphicsMode, DisplayMode displayMode) {
        WebGL graphics = new WebGL(graphicsMode, displayMode.canvas());
        return new TeaRenderer(displayMode, graphics);
    }

    public static TeaRenderer withPixi(DisplayMode displayMode) {
        PixiGraphics graphics = new PixiGraphics(displayMode.canvas());
        return new TeaRenderer(displayMode, graphics);
    }

    public static TeaRenderer withThree(DisplayMode displayMode) {
        ThreeGraphics graphics = new ThreeGraphics(displayMode.canvas());
        return new TeaRenderer(displayMode, graphics);
    }
}

