/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.util.function.Consumer;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.DisplayListLocation;
import nl.colorize.multimedialib.stage.Graphic2D;

public class Container
implements Graphic2D {
    private DisplayListLocation location = new DisplayListLocation(this);
    private String name;

    public Container(String name) {
        this.name = name;
    }

    public Container() {
        this(null);
    }

    public void addChild(Graphic2D child) {
        child.getLocation().attach(this);
    }

    public void addChild(Graphic2D child, Point2D relativePosition) {
        this.addChild(child);
        child.getTransform().setPosition(relativePosition);
    }

    public void addChild(Graphic2D child, float relativeX, float relativeY) {
        this.addChild(child);
        child.getTransform().setPosition(relativeX, relativeY);
    }

    public Container addChildContainer() {
        Container child = new Container();
        this.addChild(child);
        return child;
    }

    public void removeChild(Graphic2D child) {
        child.getLocation().detach();
    }

    public void clearChildren() {
        this.location.getRemovedChildren().push(this.location.getChildren());
        this.location.getChildren().clear();
        this.location.getAddedChildren().clear();
    }

    public Iterable<Graphic2D> getChildren() {
        return this.location.getChildren();
    }

    @Deprecated
    public <T extends Graphic2D> void forEach(Class<T> type, Consumer<T> callback) {
        for (Graphic2D child : this.location.getChildren()) {
            if (child.getClass() != type) continue;
            callback.accept(child);
        }
    }

    @Override
    public Rect getStageBounds() {
        if (this.location.getChildren().isEmpty()) {
            return new Rect(0.0f, 0.0f, 0.0f, 0.0f);
        }
        Rect firstChildBounds = this.location.getChildren().getFirst().getStageBounds();
        float x0 = firstChildBounds.x();
        float y0 = firstChildBounds.y();
        float x1 = firstChildBounds.getEndX();
        float y1 = firstChildBounds.getEndY();
        for (int i = 1; i < this.location.getChildren().size(); ++i) {
            Rect childBounds = this.location.getChildren().get(i).getStageBounds();
            x0 = Math.min(x0, childBounds.x());
            y0 = Math.min(y0, childBounds.y());
            x1 = Math.max(x1, childBounds.getEndX());
            y1 = Math.max(y1, childBounds.getEndY());
        }
        return Rect.fromPoints(x0, y0, x1, y1);
    }

    @Override
    public void updateGraphics(Timer sceneTime) {
        for (Graphic2D child : this.location.getChildren()) {
            child.updateGraphics(sceneTime);
        }
    }

    public String toString() {
        if (this.name == null) {
            return "Container [" + this.location.getChildren().size() + "]";
        }
        return "Container [" + this.name + ", " + this.location.getChildren().size() + "]";
    }

    @Override
    public DisplayListLocation getLocation() {
        return this.location;
    }
}

