/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import nl.colorize.multimedialib.math.Angle;
import nl.colorize.multimedialib.math.Buffer;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.stats.Aggregate;

public final class DisplayListLocation {
    private UUID id = UUID.randomUUID();
    private Graphic2D graphic;
    private Transform localTransform;
    private Transform globalTransform;
    private Graphic2D parent;
    private List<Graphic2D> children;
    private Buffer<Graphic2D> addedChildren;
    private Buffer<Graphic2D> removedChildren;

    protected DisplayListLocation(Graphic2D graphic) {
        this.graphic = graphic;
        this.localTransform = new LocalTransform();
        this.globalTransform = new Transform();
        this.parent = null;
        this.children = new ArrayList<Graphic2D>();
        this.addedChildren = new Buffer();
        this.removedChildren = new Buffer();
    }

    protected void attach(Graphic2D newParent) {
        Preconditions.checkNotNull((Object)newParent, (Object)"Cannot attach to null parent");
        Preconditions.checkArgument((!newParent.equals(this.graphic) ? 1 : 0) != 0, (Object)"Cannot attach to itself");
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"Already attached to parent");
        this.parent = newParent;
        this.parent.getLocation().children.add(this.graphic);
        this.parent.getLocation().addedChildren.push(this.graphic);
        ((LocalTransform)this.localTransform).propagate();
    }

    public void detach() {
        if (this.parent != null && this.parent.getLocation().children.remove(this.graphic)) {
            this.parent.getLocation().addedChildren.remove(this.graphic);
            this.parent.getLocation().removedChildren.push(this.graphic);
            this.parent = null;
        }
    }

    public UUID getId() {
        return this.id;
    }

    public Graphic2D getGraphic() {
        return this.graphic;
    }

    public Transform getLocalTransform() {
        return this.localTransform;
    }

    public Transform getGlobalTransform() {
        return this.globalTransform;
    }

    public Graphic2D getParent() {
        return this.parent;
    }

    public List<Graphic2D> getChildren() {
        return this.children;
    }

    public Buffer<Graphic2D> getAddedChildren() {
        return this.addedChildren;
    }

    public Buffer<Graphic2D> getRemovedChildren() {
        return this.removedChildren;
    }

    private class LocalTransform
    extends Transform {
        private LocalTransform() {
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.propagate();
        }

        @Override
        public void setPosition(Point2D position) {
            super.setPosition(position);
            this.propagate();
        }

        @Override
        public void setRotation(Angle rotation) {
            super.setRotation(rotation);
            this.propagate();
        }

        @Override
        public void setScaleX(float scaleX) {
            super.setScaleX(scaleX);
            this.propagate();
        }

        @Override
        public void setScaleY(float scaleY) {
            super.setScaleY(scaleY);
            this.propagate();
        }

        @Override
        public void setFlipHorizontal(boolean flipHorizontal) {
            super.setFlipHorizontal(flipHorizontal);
            this.propagate();
        }

        @Override
        public void setFlipVertical(boolean flipVertical) {
            super.setFlipVertical(flipVertical);
            this.propagate();
        }

        @Override
        public void setAlpha(float alpha) {
            super.setAlpha(alpha);
            this.propagate();
        }

        @Override
        public void setMaskColor(ColorRGB maskColor) {
            super.setMaskColor(maskColor);
            this.propagate();
        }

        private void propagate() {
            if (DisplayListLocation.this.parent == null) {
                DisplayListLocation.this.globalTransform.set(this);
            } else {
                Transform parentTransform = DisplayListLocation.this.parent.getLocation().globalTransform;
                this.propagate(parentTransform);
            }
            for (Graphic2D child : DisplayListLocation.this.children) {
                LocalTransform childTransform = (LocalTransform)child.getLocation().localTransform;
                childTransform.propagate();
            }
        }

        private void propagate(Transform parentTransform) {
            DisplayListLocation.this.globalTransform.setVisible(this.visible && parentTransform.visible);
            DisplayListLocation.this.globalTransform.setPosition(this.position.move(parentTransform.position));
            DisplayListLocation.this.globalTransform.setRotation(this.rotation.degrees() + parentTransform.rotation.degrees());
            DisplayListLocation.this.globalTransform.setScaleX(Aggregate.multiplyPercentage((float)this.scaleX, (float)parentTransform.scaleX));
            DisplayListLocation.this.globalTransform.setScaleY(Aggregate.multiplyPercentage((float)this.scaleY, (float)parentTransform.scaleY));
            DisplayListLocation.this.globalTransform.setFlipHorizontal(this.flipHorizontal || parentTransform.flipHorizontal);
            DisplayListLocation.this.globalTransform.setFlipVertical(this.flipVertical || parentTransform.flipVertical);
            DisplayListLocation.this.globalTransform.setAlpha(Aggregate.multiplyPercentage((float)this.alpha, (float)parentTransform.alpha));
            DisplayListLocation.this.globalTransform.setMaskColor(this.maskColor != null ? this.maskColor : parentTransform.maskColor);
        }
    }
}

