/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontStyle;

public record FontFace(MediaLoader owner, FilePointer origin, String family, FontStyle style) {
    public FontFace derive(FontStyle style) {
        return new FontFace(this.owner, this.origin, this.family, style);
    }

    public FontFace derive(int size) {
        return this.derive(new FontStyle(size, this.style.bold(), this.style.color()));
    }

    public FontFace derive(int size, boolean bold) {
        return this.derive(new FontStyle(size, bold, this.style.color()));
    }

    public FontFace derive(ColorRGB color) {
        return this.derive(new FontStyle(this.style.size(), this.style.bold(), color));
    }

    public FontFace scale(Canvas canvas) {
        int actualDisplaySize = Math.round(canvas.getZoomLevel() * (float)this.style.size());
        return this.derive(new FontStyle(actualDisplaySize, this.style.bold(), this.style.color()));
    }

    @Override
    public String toString() {
        return this.family + " @ " + String.valueOf(this.style);
    }
}

