/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.DisplayListLocation;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Transform;

public class Primitive
implements Graphic2D {
    private final DisplayListLocation location = new DisplayListLocation(this);
    private Shape shape;
    private ColorRGB color;
    private float stroke;

    public Primitive(Shape shape, ColorRGB color) {
        this.shape = shape;
        this.color = color;
        this.stroke = 1.0f;
    }

    public Primitive(Shape shape, ColorRGB color, float alpha) {
        this(shape, color);
        this.getTransform().setAlpha(alpha);
    }

    @Override
    public Rect getStageBounds() {
        Transform globalTransform = this.getGlobalTransform();
        return this.shape.reposition(globalTransform.getPosition()).getBoundingBox();
    }

    @Override
    public void updateGraphics(Timer sceneTime) {
    }

    public String toString() {
        return this.shape.getClass().getSimpleName();
    }

    @Override
    public DisplayListLocation getLocation() {
        return this.location;
    }

    public Shape getShape() {
        return this.shape;
    }

    public ColorRGB getColor() {
        return this.color;
    }

    public float getStroke() {
        return this.stroke;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setColor(ColorRGB color) {
        this.color = color;
    }

    public void setStroke(float stroke) {
        this.stroke = stroke;
    }
}

