/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.logging.Logger;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.multimedialib.stage.World3D;
import nl.colorize.util.LogHelper;

public class Stage {
    private Canvas canvas;
    private FrameStats frameStats;
    private Container root;
    private World3D world;
    private ColorRGB backgroundColor;
    private static final String ROOT_CONTAINER_NAME = "$$root";
    private static final float SAFE_ZONE = 128.0f;
    private static final Logger LOGGER = LogHelper.getLogger(Stage.class);

    public Stage(GraphicsMode graphicsMode, Canvas canvas, FrameStats frameStats) {
        this.canvas = canvas;
        this.frameStats = frameStats;
        this.root = new Container(ROOT_CONTAINER_NAME);
        this.world = graphicsMode == GraphicsMode.MODE_3D ? new World3D() : null;
        this.backgroundColor = ColorRGB.BLACK;
    }

    public Container addContainer() {
        Container container = new Container();
        this.root.addChild(container);
        return container;
    }

    public Container addContainer(String name) {
        Container container = new Container(name);
        this.root.addChild(container);
        return container;
    }

    public void visit(StageVisitor visitor, Timer sceneTime) {
        visitor.prepareStage(this);
        visitor.drawBackground(this.backgroundColor);
        this.visitGraphic(this.root, visitor, sceneTime);
    }

    private void visitGraphic(Graphic2D graphic, StageVisitor visitor, Timer sceneTime) {
        if (!this.shouldDraw(graphic, visitor)) {
            return;
        }
        if (!(graphic instanceof Container)) {
            graphic.updateGraphics(sceneTime);
        }
        Graphic2D graphic2D = graphic;
        Objects.requireNonNull(graphic2D);
        Graphic2D graphic2D2 = graphic2D;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Container.class, Sprite.class, Primitive.class, Text.class}, (Object)graphic2D2, n)) {
            case 0: {
                Container container = (Container)graphic2D2;
                this.visitContainer(container, visitor, sceneTime);
                break;
            }
            case 1: {
                Sprite sprite = (Sprite)graphic2D2;
                visitor.drawSprite(sprite);
                break;
            }
            case 2: {
                Primitive primitive = (Primitive)graphic2D2;
                this.visitPrimitive(primitive, visitor);
                break;
            }
            case 3: {
                Text text = (Text)graphic2D2;
                visitor.drawText(text);
                break;
            }
            default: {
                LOGGER.warning("Unknown graphics type: " + String.valueOf(graphic.getClass()));
            }
        }
        this.frameStats.countGraphics(graphic);
    }

    private boolean shouldDraw(Graphic2D graphic, StageVisitor visitor) {
        if (visitor.shouldVisitAllGraphics() || graphic instanceof Container) {
            return true;
        }
        if (!graphic.getTransform().isVisible() || !graphic.getGlobalTransform().isVisible()) {
            return false;
        }
        Rect safeCanvasBounds = new Rect(this.canvas.getBounds().x() - 128.0f, this.canvas.getBounds().y() - 128.0f, this.canvas.getBounds().width() + 256.0f, this.canvas.getBounds().height() + 256.0f);
        return graphic.getStageBounds().intersects(safeCanvasBounds);
    }

    private void visitContainer(Container container, StageVisitor visitor, Timer sceneTime) {
        visitor.visitContainer(container);
        for (Graphic2D child : container.getChildren()) {
            this.visitGraphic(child, visitor, sceneTime);
        }
    }

    private void visitPrimitive(Primitive graphic, StageVisitor visitor) {
        Shape displayedShape;
        Transform globalTransform = graphic.getGlobalTransform();
        Shape shape = displayedShape = graphic.getShape().reposition(globalTransform.getPosition());
        Objects.requireNonNull(shape);
        Shape shape2 = shape;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Line.class, SegmentedLine.class, Rect.class, Circle.class, Polygon.class}, (Object)shape2, n)) {
            case 0: {
                Line line = (Line)shape2;
                visitor.drawLine(graphic, line);
                break;
            }
            case 1: {
                SegmentedLine sLine = (SegmentedLine)shape2;
                visitor.drawSegmentedLine(graphic, sLine);
                break;
            }
            case 2: {
                Rect rect = (Rect)shape2;
                visitor.drawRect(graphic, rect);
                break;
            }
            case 3: {
                Circle circle = (Circle)shape2;
                visitor.drawCircle(graphic, circle);
                break;
            }
            case 4: {
                Polygon polygon = (Polygon)shape2;
                visitor.drawPolygon(graphic, polygon);
                break;
            }
            default: {
                LOGGER.warning("Unknown primitive: " + String.valueOf(displayedShape.getClass()));
            }
        }
    }

    public void clear() {
        this.root.clearChildren();
        if (this.world != null) {
            this.world.clear();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Stage\n");
        this.append(buffer, this.root, 1);
        if (this.world != null) {
            buffer.append("World\n");
            for (PolygonModel model : this.world.getChildren()) {
                this.append(buffer, model);
            }
        }
        return buffer.toString();
    }

    private void append(StringBuilder buffer, Graphic2D graphic, int depth) {
        buffer.append("    ".repeat(depth));
        buffer.append(graphic.toString());
        buffer.append("\n");
        if (graphic instanceof Container) {
            Container container = (Container)graphic;
            for (Graphic2D child : container.getChildren()) {
                this.append(buffer, child, depth + 1);
            }
        }
    }

    private void append(StringBuilder buffer, PolygonModel model) {
        buffer.append("    ");
        buffer.append(model.toString());
        buffer.append("\n");
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public FrameStats getFrameStats() {
        return this.frameStats;
    }

    public Container getRoot() {
        return this.root;
    }

    public World3D getWorld() {
        return this.world;
    }

    public ColorRGB getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(ColorRGB backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

