/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.DisplayListLocation;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Transform;

public class Text
implements Graphic2D {
    private final DisplayListLocation location = new DisplayListLocation(this);
    private List<String> lines = Collections.emptyList();
    private FontFace font;
    private Align align;
    private int lineWidth;
    private float lineHeight;
    private static final Splitter LINE_BOUNDARY = Splitter.on((char)'\n');
    private static final Splitter WORD_BOUNDARY = Splitter.on((char)' ');
    private static final float ESTIMATED_CHAR_WIDTH_FACTOR = 0.6f;
    private static final float ESTIMATED_LINE_HEIGHT_FACTOR = 1.8f;

    public Text(String text, FontFace font, Align align, int lineWidth) {
        this.font = font;
        this.align = align;
        this.lineWidth = lineWidth;
        this.lineHeight = font == null ? 10.0f : (float)font.style().size() * 1.8f;
        this.setText(text);
    }

    public Text(String text, FontFace font, Align align) {
        this(text, font, align, 0);
    }

    public Text(String text, FontFace font) {
        this(text, font, Align.LEFT);
    }

    public void setText(String text) {
        this.setText(List.of(text));
    }

    public void setText(List<String> text) {
        this.lines = text.isEmpty() ? Collections.emptyList() : text.stream().flatMap(line -> LINE_BOUNDARY.splitToStream((CharSequence)line)).flatMap(line -> this.processLine((String)line)).toList();
    }

    private Stream<String> processLine(String line) {
        if (this.lineWidth <= 0 || line.isEmpty()) {
            return Stream.of(line);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentLineBuffer = new StringBuilder();
        int estimatedCharactersPerLine = (int)Math.floor((float)this.lineWidth / this.estimateCharWidth());
        for (String word : WORD_BOUNDARY.split((CharSequence)line)) {
            if (!currentLineBuffer.isEmpty()) {
                if (currentLineBuffer.length() + word.length() + 1 > estimatedCharactersPerLine) {
                    result.add(currentLineBuffer.toString());
                    currentLineBuffer.setLength(0);
                } else {
                    currentLineBuffer.append(" ");
                }
            }
            currentLineBuffer.append(word);
        }
        if (!currentLineBuffer.isEmpty()) {
            result.add(currentLineBuffer.toString());
        }
        return result.stream();
    }

    public void forLines(BiConsumer<Integer, String> callback) {
        for (int i = 0; i < this.lines.size(); ++i) {
            callback.accept(i, this.lines.get(i));
        }
    }

    @Override
    public Rect getStageBounds() {
        Transform globalTransform = this.getGlobalTransform();
        Point2D position = globalTransform.getPosition();
        int longestLine = this.lines.stream().mapToInt(String::length).max().orElse(1);
        float approximateWidth = (float)longestLine * this.estimateCharWidth();
        float approximateHeight = this.font.style().size() * this.lines.size();
        return Rect.around(position, approximateWidth, approximateHeight);
    }

    private float estimateCharWidth() {
        return (float)this.font.style().size() * 0.6f;
    }

    @Override
    public void updateGraphics(Timer sceneTime) {
    }

    public String toString() {
        Object preview = "";
        if (!this.lines.isEmpty()) {
            preview = this.lines.getFirst();
        }
        if (((String)preview).length() > 20) {
            preview = ((String)preview).substring(0, 20) + "...";
        }
        return "Text [" + (String)preview + "]";
    }

    @Override
    public DisplayListLocation getLocation() {
        return this.location;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public FontFace getFont() {
        return this.font;
    }

    public Align getAlign() {
        return this.align;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public void setFont(FontFace font) {
        this.font = font;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
    }
}

