/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.PolygonModel;

public class World3D
implements Updatable {
    private Point3D cameraPosition = new Point3D(10.0f, 10.0f, 10.0f);
    private Point3D cameraTarget = new Point3D(0.0f, 0.0f, 0.0f);
    private ColorRGB ambientLight = new ColorRGB(100, 100, 100);
    private ColorRGB lightColor = new ColorRGB(200, 200, 200);
    private Point3D lightPosition = new Point3D(-1.0f, -0.8f, -0.2f);
    private final List<PolygonModel> children = new ArrayList<PolygonModel>();

    protected World3D() {
    }

    @Override
    public void update(float deltaTime) {
        for (PolygonModel model : this.children) {
            model.update(deltaTime);
        }
    }

    public void clear() {
        this.children.clear();
    }

    public String toString() {
        return "World3D";
    }

    public Point3D getCameraPosition() {
        return this.cameraPosition;
    }

    public Point3D getCameraTarget() {
        return this.cameraTarget;
    }

    public ColorRGB getAmbientLight() {
        return this.ambientLight;
    }

    public ColorRGB getLightColor() {
        return this.lightColor;
    }

    public Point3D getLightPosition() {
        return this.lightPosition;
    }

    public List<PolygonModel> getChildren() {
        return this.children;
    }

    public void setCameraPosition(Point3D cameraPosition) {
        this.cameraPosition = cameraPosition;
    }

    public void setCameraTarget(Point3D cameraTarget) {
        this.cameraTarget = cameraTarget;
    }

    public void setAmbientLight(ColorRGB ambientLight) {
        this.ambientLight = ambientLight;
    }

    public void setLightColor(ColorRGB lightColor) {
        this.lightColor = lightColor;
    }

    public void setLightPosition(Point3D lightPosition) {
        this.lightPosition = lightPosition;
    }
}

