/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.RandomGenerator;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.PeerConnection;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.renderer.teavm.PeerMessage;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.scene.effect.Effect;
import nl.colorize.multimedialib.scene.effect.ParticleWipe;
import nl.colorize.multimedialib.scene.effect.PerformanceMonitor;
import nl.colorize.multimedialib.scene.effect.SwipeTracker;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.Animation;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.SpriteAtlas;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.util.DateParser;
import nl.colorize.util.LogHelper;
import nl.colorize.util.PropertyUtils;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;
import nl.colorize.util.http.Headers;
import nl.colorize.util.http.PostData;

public class Demo2D
implements Scene,
ErrorHandler {
    private SceneContext context;
    private Container contentLayer;
    private Container hudLayer;
    private SpriteAtlas marioSpriteSheet;
    private FontFace font;
    private List<Mario> marios;
    private Audio audioClip;
    private Text hud;
    private PerformanceMonitor performanceMonitor;
    public static final int DEFAULT_CANVAS_WIDTH = 800;
    public static final int DEFAULT_CANVAS_HEIGHT = 600;
    private static final FilePointer MARIO_SPRITES_FILE = new FilePointer("demo/demo.png");
    private static final FilePointer AUDIO_FILE = new FilePointer("demo/demo-sound.mp3");
    private static final FilePointer COLORIZE_LOGO = new FilePointer("colorize-logo.png");
    private static final List<String> DIRECTIONS = List.of("north", "east", "south", "west");
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 25;
    private static final ColorRGB RED_BUTTON = new ColorRGB(228, 93, 97);
    private static final ColorRGB GREEN_BUTTON = ColorRGB.parseHex("#72A725");
    private static final ColorRGB PINK_BUTTON = ColorRGB.parseHex("#B75797");
    private static final ColorRGB BLUE_BUTTON = ColorRGB.parseHex("#43A1C7");
    private static final ColorRGB BACKGROUND_COLOR = ColorRGB.parseHex("#343434");
    private static final ColorRGB ALT_BACKGROUND_COLOR = ColorRGB.parseHex("#EBEBEB");
    private static final ColorRGB COLORIZE_COLOR = ColorRGB.parseHex("#e45d61");
    private static final String EXAMPLE_URL = "https://dashboard.clrz.nl/rest/echo";
    private static final List<ColorRGB> SWIPE_COLORS = List.of(ColorRGB.RED, ColorRGB.GREEN, ColorRGB.BLUE, ColorRGB.YELLOW);
    private static final Logger LOGGER = LogHelper.getLogger(Demo2D.class);

    @Override
    public void start(SceneContext context) {
        this.context = context;
        this.contentLayer = context.getStage().addContainer();
        this.hudLayer = context.getStage().addContainer();
        MediaLoader mediaLoader = context.getMediaLoader();
        context.getStage().setBackgroundColor(BACKGROUND_COLOR);
        this.initMarioSprites(mediaLoader);
        this.marios = new ArrayList<Mario>();
        this.addMarios();
        this.font = mediaLoader.loadDefaultFont(ColorRGB.WHITE);
        this.audioClip = mediaLoader.loadAudio(AUDIO_FILE);
        this.initHUD();
        this.initEffects();
        this.attachSwipeTracker();
        this.sendHttpRequest(context.getNetwork());
        context.getMediaLoader().saveApplicationData("MultimediaLib-Demo2D", PropertyUtils.loadProperties((String)("demo=" + DateParser.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm"))));
        this.performanceMonitor = new PerformanceMonitor(false);
        this.performanceMonitor.setActive(false);
        context.attach(this.performanceMonitor);
    }

    private void initMarioSprites(MediaLoader mediaLoader) {
        Image image = mediaLoader.loadImage(MARIO_SPRITES_FILE);
        this.marioSpriteSheet = new SpriteAtlas();
        int y = 0;
        for (String direction : DIRECTIONS) {
            for (int i = 0; i <= 4; ++i) {
                this.marioSpriteSheet.add(direction + "_" + i, image, new Region(i * 48, y, 48, 64));
            }
            y += 64;
        }
    }

    private void initHUD() {
        this.hud = new Text("", this.font);
        this.hud.getTransform().setPosition(20.0f, 20.0f);
        this.hud.setLineHeight(20.0f);
        this.hudLayer.addChild(this.hud);
        this.createButton(this.context, "Add sprites", RED_BUTTON, 0, this::addMarios);
        this.createButton(this.context, "Remove sprites", RED_BUTTON, 30, () -> this.removeMarios(10));
        this.createButton(this.context, "Play sound", GREEN_BUTTON, 60, this.audioClip::play);
        this.createButton(this.context, "Background", GREEN_BUTTON, 90, this::toggleBackgroundColor);
        this.createButton(this.context, "Cause error", PINK_BUTTON, 120, this::causeError);
        this.createButton(this.context, "Performance", PINK_BUTTON, 150, this::togglePerformanceMonitor);
        if (this.context.getNetwork().isPeerToPeerSupported()) {
            this.createButton(this.context, "Open connection", BLUE_BUTTON, 180, this::openPeerConnection);
            this.createButton(this.context, "Join connection", BLUE_BUTTON, 210, this::joinPeerConnection);
        }
    }

    private void createButton(SceneContext context, String label, ColorRGB color, int y, Runnable click) {
        Primitive bounds = new Primitive(new Rect(0.0f, 0.0f, 100.0f, 25.0f), color);
        this.hudLayer.addChild(bounds);
        Text text = new Text(label, this.font, Align.CENTER);
        this.hudLayer.addChild(text);
        context.attach(deltaTime -> {
            bounds.getTransform().setPosition(context.getCanvas().getWidth() - 100 - 2, y + 2);
            text.getTransform().setPosition((float)context.getCanvas().getWidth() - 50.0f, y + 19);
        });
        Effect.forClickHandler(bounds, click).attach(context);
    }

    private void initEffects() {
        Timeline timeline = new Timeline(Interpolation.LINEAR, true);
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(2.0f, 1.0f);
        timeline.addKeyFrame(4.0f, 0.0f);
        Sprite sprite = new Sprite(this.context.getMediaLoader().loadImage(COLORIZE_LOGO));
        this.hudLayer.addChild(sprite);
        Effect.forTimeline(timeline, value -> {
            sprite.setPosition((float)this.context.getCanvas().getWidth() / 2.0f, this.context.getCanvas().getHeight() - 50);
            sprite.getTransform().setScale(80.0f + value.floatValue() * 40.0f);
        }).addFrameHandler(dt -> sprite.getTransform().addRotation(dt * 100.0f)).attach(this.context);
        Image diamond = this.context.getMediaLoader().loadImage(ParticleWipe.DIAMOND);
        ParticleWipe wipe = new ParticleWipe(diamond, COLORIZE_COLOR, 1.5f, true);
        this.context.attach(wipe);
    }

    private void attachSwipeTracker() {
        SwipeTracker swipeTracker = new SwipeTracker(50.0f);
        this.context.attach(swipeTracker);
        this.context.attach(deltaTime -> {
            ImmutableList swipes = ImmutableList.copyOf(swipeTracker.getSwipes().flush());
            for (int i = 0; i < swipes.size(); ++i) {
                this.drawSwipeMarker((Line)swipes.get(i), SWIPE_COLORS.get(i % SWIPE_COLORS.size()));
            }
        });
    }

    private void drawSwipeMarker(Line swipe, ColorRGB color) {
        Primitive swipeMarker = new Primitive(swipe, color);
        swipeMarker.setStroke(2.0f);
        this.hudLayer.addChild(swipeMarker);
        Timeline timeline = new Timeline().addKeyFrame(0.0f, 100.0f).addKeyFrame(1.0f, 100.0f).addKeyFrame(1.5f, 0.0f);
        this.context.attach(Effect.forPrimitiveAlpha(swipeMarker, timeline));
    }

    private void sendHttpRequest(Network network) {
        Headers headers = Headers.of((String)"Accept", (String)"text/plain", (String[])new String[0]);
        PostData data = PostData.create((String)"message", (String)"1234", (String[])new String[0]);
        Text info = new Text("Network request pending", this.font, Align.RIGHT);
        info.setPosition(this.context.getCanvas().getWidth() - 20, this.context.getCanvas().getHeight() - 100);
        this.hudLayer.addChild(info);
        network.post(EXAMPLE_URL, headers, data).subscribe(response -> {
            ArrayList<String> text = new ArrayList<String>();
            text.add("Network request succeeded");
            text.add("Content-Type: " + response.getContentType().orElse("?"));
            text.addAll(Splitter.on((String)"\n").omitEmptyStrings().splitToList((CharSequence)response.readBody()));
            info.setText(text);
        }, e -> info.setText("Failed to send network request"));
    }

    private void toggleBackgroundColor() {
        Stage stage = this.context.getStage();
        if (stage.getBackgroundColor().equals(BACKGROUND_COLOR)) {
            stage.setBackgroundColor(ALT_BACKGROUND_COLOR);
        } else {
            stage.setBackgroundColor(BACKGROUND_COLOR);
        }
    }

    private void causeError() {
        throw new RuntimeException("Intentional error");
    }

    private void togglePerformanceMonitor() {
        this.performanceMonitor.setActive(!this.performanceMonitor.isActive());
    }

    private PeerConnection openPeerConnection() {
        PeerConnection peerConnection = this.context.getNetwork().openPeerConnection();
        this.context.attach(() -> {
            for (PeerMessage message : peerConnection.getReceivedMessages().flush()) {
                LOGGER.info("Received message: " + message.type() + " / " + message.value());
                if (message.type().equals("init")) {
                    this.context.getInput().fillClipboard(message.value());
                    continue;
                }
                if (message.type().equals("connect")) continue;
                this.showNotification("Received message: " + message.value());
            }
        });
        return peerConnection;
    }

    private void joinPeerConnection() {
        String id = this.context.getInput().requestTextInput("Peer-to-peer connection ID", "");
        if (id != null && !id.isEmpty()) {
            PeerConnection peerConnection = this.openPeerConnection();
            peerConnection.connect(id);
            peerConnection.sendMessage("Hello from a peer-to-peer connection");
        }
    }

    @Override
    public void onError(SceneContext context, Exception cause) {
        this.showNotification("Error:\n\n" + cause.getMessage());
    }

    private void showNotification(String message) {
        Text notification = new Text(message, this.font, Align.CENTER);
        notification.getTransform().setPosition(this.context.getCanvas().getCenter());
        this.hudLayer.addChild(notification);
        Timeline timeline = new Timeline(Interpolation.LINEAR).addKeyFrame(0.0f, this.context.getCanvas().getCenter().y()).addKeyFrame(4.0f, this.context.getCanvas().getCenter().y() - 100.0f);
        Effect.delay(4.0f, () -> this.hudLayer.removeChild(notification)).addTimelineHandler(timeline, value -> notification.getTransform().setY(value.floatValue())).attach(this.context);
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        InputDevice inputDevice = context.getInput();
        this.handleClick(inputDevice);
        this.handleSystemControls(inputDevice);
        for (Mario mario : this.marios) {
            mario.update(deltaTime);
        }
        List<String> info = context.getDebugInformation();
        info.add("Sprites:  " + this.marios.size());
        info.add("Keyboard:  " + inputDevice.isKeyboardAvailable());
        info.add("Touch:  " + inputDevice.isTouchAvailable());
        this.hud.setText(info);
    }

    private void handleClick(InputDevice input) {
        for (Pointer pointer : input.getPointers()) {
            if (this.checkMarioClick(pointer)) {
                return;
            }
            if (!pointer.isReleased()) continue;
            this.createTouchMarker(pointer.getPosition());
        }
    }

    private boolean checkMarioClick(Pointer pointer) {
        for (Mario mario : this.marios) {
            if (!pointer.isReleased(mario.sprite.getStageBounds())) continue;
            mario.mask = !mario.mask;
            return true;
        }
        return false;
    }

    private void handleSystemControls(InputDevice input) {
        if (input.isKeyReleased(KeyCode.N9) || input.isKeyReleased(KeyCode.B)) {
            this.toggleBackgroundColor();
        }
    }

    private void createTouchMarker(Point2D position) {
        Timeline timeline = new Timeline().addKeyFrame(0.0f, 100.0f).addKeyFrame(1.0f, 100.0f).addKeyFrame(1.5f, 0.0f);
        Container container = new Container();
        container.getTransform().setPosition(position);
        container.addChild(new Primitive(new Circle(Point2D.ORIGIN, 4.0f), ColorRGB.WHITE));
        container.addChild(new Text(position.toString(), this.font, Align.LEFT), 4.0f, -4.0f);
        this.hudLayer.addChild(container);
        Effect effect = Effect.forTimeline(timeline, value -> container.getTransform().setAlpha(value.floatValue()));
        effect.removeAfterwards(container);
        this.context.attach(effect);
    }

    public void addMarios() {
        int amount = this.marios.size() >= 100 ? 100 : 20;
        for (int i = 0; i < amount; ++i) {
            Sprite marioSprite = this.createMarioSprite();
            Mario mario = new Mario(marioSprite, this.context.getCanvas());
            this.marios.add(mario);
            mario.update(0.0f);
            this.contentLayer.addChild(marioSprite);
        }
    }

    private Sprite createMarioSprite() {
        Sprite marioSprite = new Sprite();
        for (String direction : DIRECTIONS) {
            List<Image> frames = this.marioSpriteSheet.get(List.of(direction + "_0", direction + "_1", direction + "_2", direction + "_3", direction + "_4"));
            Animation anim = new Animation(frames, 0.1f, true);
            marioSprite.addGraphics(direction, anim);
        }
        return marioSprite;
    }

    private void removeMarios(int amount) {
        for (int i = 0; i < amount && !this.marios.isEmpty(); ++i) {
            Mario removed = this.marios.remove(this.marios.size() - 1);
            this.contentLayer.removeChild(removed.sprite);
        }
    }

    private static class Mario
    implements Updatable {
        private Sprite sprite;
        private Canvas canvas;
        private int direction;
        private float speed;
        private boolean mask;

        public Mario(Sprite sprite, Canvas canvas) {
            this.sprite = sprite;
            this.canvas = canvas;
            sprite.getTransform().setPosition(RandomGenerator.pickPoint(canvas.getBounds()));
            this.direction = RandomGenerator.getInt(0, 4);
            this.speed = RandomGenerator.getFloat(20.0f, 80.0f);
            this.mask = false;
        }

        @Override
        public void update(float deltaTime) {
            this.sprite.changeGraphics(DIRECTIONS.get(this.direction));
            Point2D position = this.sprite.getTransform().getPosition();
            Point2D newPosition = switch (this.direction) {
                case 0 -> new Point2D(position.x(), position.y() - this.speed * deltaTime);
                case 1 -> new Point2D(position.x() + this.speed * deltaTime, position.y());
                case 2 -> new Point2D(position.x(), position.y() + this.speed * deltaTime);
                case 3 -> new Point2D(position.x() - this.speed * deltaTime, position.y());
                default -> position;
            };
            this.sprite.getTransform().setPosition(newPosition);
            this.sprite.getTransform().setMaskColor(this.mask ? ColorRGB.WHITE : null);
            this.checkBounds();
        }

        private void checkBounds() {
            Point2D position = this.sprite.getTransform().getPosition();
            if (!this.canvas.getBounds().contains(position)) {
                this.direction = (this.direction + 2) % 4;
            }
        }
    }
}

