/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.RandomGenerator;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.World3D;

public class Demo3D
implements Scene,
ErrorHandler {
    private SceneContext context;
    private FontFace font;
    private Image logo;
    private List<PolygonModel> models;
    private List<Point2D> walkVectors;
    private Point2D pointer = new Point2D(0.0f, 0.0f);
    private Text hud;
    public static final int CANVAS_WIDTH = 800;
    public static final int CANVAS_HEIGHT = 600;
    private static final FilePointer MODEL_FILE = new FilePointer("demo/colorize-logo.gltf");
    private static final FilePointer LOGO_FILE = new FilePointer("colorize-logo.png");
    private static final float AREA_SIZE = 50.0f;
    private static final float MAX_WALK_SPEED = 0.1f;

    @Override
    public void start(SceneContext context) {
        this.context = context;
        MediaLoader mediaLoader = context.getMediaLoader();
        this.font = mediaLoader.loadDefaultFont(ColorRGB.WHITE);
        this.logo = mediaLoader.loadImage(LOGO_FILE);
        World3D stage = context.getStage().getWorld();
        this.createFloor(stage);
        this.createModels(stage, mediaLoader);
        stage.setCameraPosition(new Point3D(0.0f, 30.0f, 30.000002f));
        stage.setCameraTarget(new Point3D(0.0f, 0.0f, 0.0f));
        this.hud = new Text("", this.font);
        this.hud.setPosition(20.0f, 20.0f);
        this.hud.setLineHeight(20.0f);
        context.getStage().getRoot().addChild(this.hud);
    }

    private void createFloor(World3D stage) {
        boolean white = true;
        for (int i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                float tileSize = 4.5454545f;
                ColorRGB color = white ? ColorRGB.WHITE : new ColorRGB(50, 50, 50);
                PolygonModel tile = this.createTile(tileSize, color, i == 0 && j == 0);
                tile.getTransform().setPosition((float)i * tileSize, 0.0f, (float)j * tileSize);
                stage.getChildren().add(tile);
                white = !white;
            }
        }
    }

    private PolygonModel createTile(float tileSize, ColorRGB color, boolean center) {
        GeometryBuilder geometryBuilder = this.context.getMediaLoader().getGeometryBuilder();
        if (center) {
            PolygonModel quad = geometryBuilder.createQuad(new Point2D(tileSize, tileSize), this.logo);
            quad.getTransform().setRotation(0.0f, 90.0f, 0.0f);
            return quad;
        }
        return geometryBuilder.createQuad(new Point2D(tileSize, tileSize), color);
    }

    private void createModels(World3D stage, MediaLoader mediaLoader) {
        this.models = new ArrayList<PolygonModel>();
        this.walkVectors = new ArrayList<Point2D>();
        PolygonModel template = mediaLoader.loadModel(MODEL_FILE);
        for (int i = 0; i < 100; ++i) {
            PolygonModel model = template.copy();
            model.getTransform().setPosition(this.generateRandomModelPosition());
            model.getTransform().setRotation(0.0f, -90.0f, 0.0f);
            stage.getChildren().add(model);
            this.models.add(model);
            this.walkVectors.add(this.generateRandomWalkVector());
        }
    }

    private Point3D generateRandomModelPosition() {
        float x = RandomGenerator.getFloat(-25.0f, 25.0f);
        float z = RandomGenerator.getFloat(-25.0f, 25.0f);
        return new Point3D(x, 0.5f, z);
    }

    private Point2D generateRandomWalkVector() {
        float x = RandomGenerator.getFloat(-0.1f, 0.1f);
        float z = RandomGenerator.getFloat(-0.1f, 0.1f);
        return new Point2D(x, z);
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        for (Pointer pointer : context.getInput().getPointers()) {
            if (!pointer.isReleased()) continue;
            this.pointer = pointer.getPosition();
        }
        this.updateModels(context.getStage());
        this.updateHUD(context.getStage());
    }

    private void updateModels(Stage stage) {
        Rect areaBounds = new Rect(-25.0f, -25.0f, 50.0f, 50.0f);
        for (int i = 0; i < this.models.size(); ++i) {
            PolygonModel model = this.models.get(i);
            Point2D walkVector = this.walkVectors.get(i);
            model.getTransform().addPosition(walkVector.x(), 0.0f, walkVector.y());
            Point3D position = model.getTransform().getPosition();
            if (areaBounds.contains(position.x(), position.z())) continue;
            Point2D walk = new Point2D(-this.walkVectors.get(i).x(), -this.walkVectors.get(i).y());
            this.walkVectors.set(i, walk);
            model.playAnimation("Cube|Spin");
        }
    }

    private void updateHUD(Stage stage) {
        List<String> info = this.context.getDebugInformation();
        info.add("Models:  " + this.models.size());
        info.add("Pointer:  " + String.valueOf(this.pointer));
        this.hud.setText(info);
    }

    @Override
    public void onError(SceneContext context, Exception cause) {
        Text errorText = new Text("Error:\n\n" + cause.getMessage(), this.font, Align.CENTER);
        errorText.getTransform().setPosition(context.getCanvas().getCenter());
        context.getStage().getRoot().addChild(errorText);
    }
}

