/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.RendererLauncher;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.tool.Demo2D;
import nl.colorize.multimedialib.tool.Demo3D;
import nl.colorize.util.cli.Arg;
import nl.colorize.util.cli.CommandLineArgumentParser;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.Popups;

public class DemoLauncher
implements ApplicationMenuListener {
    @Arg(name="-renderer", usage="Either 'java2d', 'javafx, or 'gdx'")
    protected String rendererName;
    @Arg(usage="Either '2d' or '3d'")
    protected String graphics;
    @Arg(defaultValue="60", usage="Framerate, default is 60 fps")
    protected int framerate;
    @Arg(usage="Starts the demo fullscreen instead of in a window")
    protected boolean fullscreen;
    @Arg(name="zoom", usage="Uses a fixed canvas size to display graphics")
    protected boolean canvasZoom;

    public static void main(String[] argv) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser(DemoLauncher.class);
        DemoLauncher launcher = (DemoLauncher)argParser.parse(argv, DemoLauncher.class);
        launcher.start();
    }

    private void start() {
        Canvas canvas = this.initCanvas();
        DisplayMode displayMode = new DisplayMode(canvas, this.framerate);
        GraphicsMode graphicsMode = this.getGraphicsMode();
        WindowOptions window = new WindowOptions("MultimediaLib - Demo");
        window.setAppMenu(this);
        window.setFullscreen(this.fullscreen);
        if (graphicsMode == GraphicsMode.MODE_2D) {
            Demo2D demo = new Demo2D();
            RendererLauncher.configure(displayMode, window).forDesktop2D(this.rendererName).start(demo, demo);
        } else {
            Demo3D demo = new Demo3D();
            RendererLauncher.configure(displayMode, window).forDesktop3D(this.rendererName).start(demo, demo);
        }
    }

    private Canvas initCanvas() {
        ScaleStrategy scaleStrategy = this.canvasZoom ? ScaleStrategy.scale() : ScaleStrategy.flexible();
        return new Canvas(800, 600, scaleStrategy);
    }

    private GraphicsMode getGraphicsMode() {
        return switch (this.graphics) {
            case "2d" -> GraphicsMode.MODE_2D;
            case "3d" -> GraphicsMode.MODE_3D;
            default -> throw new UnsupportedOperationException("Unknown graphics mode");
        };
    }

    public void onQuit() {
        System.exit(0);
    }

    public void onAbout() {
        Popups.message(null, (String)"MultimediaLib - demo application");
    }
}

