/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.tool.SpriteAtlasPacker;
import nl.colorize.util.FileUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.cli.Arg;
import nl.colorize.util.cli.CommandLineArgumentParser;
import nl.colorize.util.swing.Utils2D;

public class ImageManipulationTool {
    @Arg(name="input")
    protected File inputDir;
    @Arg(name="output")
    protected File outputDir;
    @Arg(defaultValue="")
    protected String outputPrefix;
    @Arg
    protected int horizontalOffset;
    @Arg
    protected int verticalOffset;
    @Arg
    protected boolean mirror;
    private int counter;
    private static final Logger LOGGER = LogHelper.getLogger(ImageManipulationTool.class);

    public static void main(String[] argv) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser("ImageManipulationTool");
        ImageManipulationTool tool = (ImageManipulationTool)argParser.parse(argv, ImageManipulationTool.class);
        try {
            tool.run();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "I/O error during image manipulation", e);
        }
    }

    protected void run() throws IOException {
        for (File imageFile : FileUtils.walkFiles((File)this.inputDir, this::isImageFile)) {
            LOGGER.info("Processing " + imageFile.getName());
            BufferedImage image = Utils2D.loadImage((File)imageFile);
            this.processImage(image);
        }
    }

    private boolean isImageFile(File file) {
        String ext = FileUtils.getFileExtension((File)file);
        return SpriteAtlasPacker.IMAGE_FILE_EXTENSIONS.contains(ext);
    }

    private void processImage(BufferedImage original) {
        if (this.horizontalOffset > 0) {
            this.applyHorizontalOffset(original);
        }
        if (this.verticalOffset > 0) {
            this.applyVerticalOffset(original);
        }
        if (this.mirror) {
            this.mirrorImage(original);
        }
    }

    private void applyHorizontalOffset(BufferedImage original) {
        for (int x = 0; x <= original.getWidth(); x += this.horizontalOffset) {
            int offset = x;
            this.generateVariant(original, g2 -> {
                g2.drawImage(original, offset, 0, null);
                g2.drawImage(original, offset - original.getWidth(), 0, null);
            });
        }
    }

    private void applyVerticalOffset(BufferedImage original) {
        for (int y = 0; y <= original.getHeight(); y += this.verticalOffset) {
            int offset = y;
            this.generateVariant(original, g2 -> {
                g2.drawImage(original, 0, offset, null);
                g2.drawImage(original, 0, offset - original.getHeight(), null);
            });
        }
    }

    private void mirrorImage(BufferedImage original) {
        int width = original.getWidth();
        int height = original.getHeight();
        this.generateVariant(original, g2 -> {
            g2.drawImage(original, 0, 0, width / 2, height / 2, 0, 0, width, height, null);
            g2.drawImage(original, width, 0, width / 2, height / 2, 0, 0, width, height, null);
            g2.drawImage(original, 0, height, width / 2, height / 2, 0, 0, width, height, null);
            g2.drawImage(original, width, height, width / 2, height / 2, 0, 0, width, height, null);
        });
    }

    private void generateVariant(BufferedImage original, Consumer<Graphics2D> drawCallback) {
        BufferedImage image = new BufferedImage(original.getWidth(), original.getHeight(), 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)image, (boolean)true, (boolean)true);
        drawCallback.accept(g2);
        g2.dispose();
        this.writePNG(image);
    }

    private void writePNG(BufferedImage image) {
        ++this.counter;
        File outputFile = new File(this.outputDir, this.outputPrefix + this.counter + ".png");
        if (outputFile.exists()) {
            LOGGER.warning(outputFile.getAbsolutePath() + " already exists");
            return;
        }
        try {
            FileUtils.mkdir((File)this.outputDir);
            Utils2D.savePNG((BufferedImage)image, (File)outputFile);
            LOGGER.info("Created " + outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write image: " + outputFile.getAbsolutePath());
        }
    }
}

