/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.RendererLauncher;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.BrowserDOM;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.tool.Demo2D;
import nl.colorize.multimedialib.tool.Demo3D;

public class TeaDemoLauncher {
    private static final int BROWSER_FRAMERATE = 60;

    public static void main(String[] args) {
        Browser.log("MultimediaLib - TeaVM Demo");
        Browser.log("Screen size: " + Browser.getScreenWidth() + "x" + Browser.getScreenHeight());
        Browser.log("Page size: " + Math.round(Browser.getPageWidth()) + "x" + Math.round(Browser.getPageHeight()));
        Canvas canvas = new Canvas(800, 600, ScaleStrategy.balanced());
        DisplayMode displayMode = new DisplayMode(canvas, 60);
        String rendererName = BrowserDOM.getQueryString().getOptionalParameter("renderer", "canvas");
        RendererLauncher.configure(displayMode).forBrowser2D(rendererName).start(TeaDemoLauncher.initDemo(), TeaDemoLauncher::logError);
    }

    private static Scene initDemo() {
        return switch (Browser.getMeta("demo", "2d")) {
            case "2d" -> new Demo2D();
            case "3d" -> new Demo3D();
            default -> throw new UnsupportedOperationException("Unknown demo");
        };
    }

    private static void logError(SceneContext context, Exception cause) {
        Browser.log("----");
        Browser.log(cause.getMessage());
        Browser.log("----");
    }
}

