/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;

public record Circle(Point2D center, float radius) implements Shape
{
    public Circle {
        Preconditions.checkArgument((radius >= 0.0f ? 1 : 0) != 0, (Object)("Invalid radius: " + radius));
    }

    public Circle(float x, float y, float radius) {
        this(new Point2D(x, y), radius);
    }

    @Override
    public Point2D getCenter() {
        return this.center;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.calculateDistance(p) <= this.radius;
    }

    public boolean intersects(Circle other) {
        return this.calculateDistance(other) <= this.radius + other.radius;
    }

    public float calculateDistance(Point2D p) {
        return this.center.distanceTo(p);
    }

    public float calculateDistance(Circle other) {
        return this.center.distanceTo(other.center);
    }

    @Override
    public Rect getBoundingBox() {
        return new Rect(this.center.x() - this.radius, this.center.y() - this.radius, 2.0f * this.radius, 2.0f * this.radius);
    }

    @Override
    public Circle reposition(Point2D offset) {
        Point2D newCenter = this.center.move(offset.x(), offset.y());
        return new Circle(newCenter, this.radius);
    }

    @Override
    public String toString() {
        return "Circle";
    }
}

