/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;

public record Line(Point2D start, Point2D end) implements Shape
{
    public Line(float startX, float startY, float endX, float endY) {
        this(new Point2D(startX, startY), new Point2D(endX, endY));
    }

    @Override
    public boolean contains(Point2D p) {
        return p.equals(this.start) || p.equals(this.end);
    }

    @Override
    public Rect getBoundingBox() {
        float x0 = Math.min(this.start.x(), this.end.x());
        float y0 = Math.min(this.start.y(), this.end.y());
        float x1 = Math.max(this.start.x(), this.end.x());
        float y1 = Math.max(this.start.y(), this.end.y());
        return Rect.fromPoints(x0, y0, x1, y1);
    }

    @Override
    public Point2D getCenter() {
        return this.getBoundingBox().getCenter();
    }

    @Override
    public Line reposition(Point2D offset) {
        return new Line(this.start.x() + offset.x(), this.start.y() + offset.y(), this.end.x() + offset.x(), this.end.y() + offset.y());
    }

    @Override
    public String toString() {
        return String.valueOf(this.start) + " -> " + String.valueOf(this.end);
    }
}

