/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import nl.colorize.multimedialib.math.Angle;
import nl.colorize.util.animation.Interpolation;

public record Point2D(float x, float y) {
    public static final Point2D ORIGIN = new Point2D(0.0f, 0.0f);
    public static final float EPSILON = 0.001f;

    public boolean isOrigin() {
        return Math.abs(this.x) < 0.001f && Math.abs(this.y) < 0.001f;
    }

    public float distanceTo(Point2D other) {
        float deltaX = Math.abs(other.x - this.x);
        float deltaY = Math.abs(other.y - this.y);
        return (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public Angle angleTo(Point2D other) {
        double radians = Math.atan2(other.y - this.y, other.x - this.x);
        float degrees = (float)Math.toDegrees(radians);
        return new Angle(degrees);
    }

    public Point2D findCenter(Point2D other) {
        float centerX = (this.x + other.x) / 2.0f;
        float centerY = (this.y + other.y) / 2.0f;
        return new Point2D(centerX, centerY);
    }

    public Point2D interpolate(Point2D other, float delta, Interpolation method) {
        float interpolatedX = method.interpolate(this.x, other.x, delta);
        float interpolatedY = method.interpolate(this.y, other.y, delta);
        return new Point2D(interpolatedX, interpolatedY);
    }

    public Point2D interpolate(Point2D other, float delta) {
        return this.interpolate(other, delta, Interpolation.LINEAR);
    }

    public Point2D move(float deltaX, float deltaY) {
        return new Point2D(this.x + deltaX, this.y + deltaY);
    }

    public Point2D move(Point2D other) {
        return this.move(other.x, other.y);
    }

    public Point2D multiply(float factor) {
        return new Point2D(this.x * factor, this.y * factor);
    }

    @Override
    public String toString() {
        return String.format("(%d, %d)", Math.round(this.x), Math.round(this.y));
    }
}

